"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _documents_panel = require("./documents_panel");
var _events_panel = require("./events_panel");
var _filtering_panel = require("./filtering_panel");
var _flyout_panel = require("./flyout_panel");
var _pipeline_panel = require("./pipeline_panel");
var _sync_callouts = require("./sync_callouts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/sync_jobs/sync_job_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SyncJobFlyout = ({
  onClose,
  syncJob
}) => {
  var _syncJob$connector$fi, _syncJob$indexed_docu, _syncJob$canceled_at, _syncJob$cancelation_, _syncJob$started_at, _syncJob$completed_at, _syncJob$last_seen, _filtering$rules, _syncJob$connector;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const filtering = syncJob !== null && syncJob !== void 0 && syncJob.connector.filtering ? Array.isArray(syncJob === null || syncJob === void 0 ? void 0 : syncJob.connector.filtering) ? syncJob === null || syncJob === void 0 ? void 0 : (_syncJob$connector$fi = syncJob.connector.filtering) === null || _syncJob$connector$fi === void 0 ? void 0 : _syncJob$connector$fi[0] : syncJob === null || syncJob === void 0 ? void 0 : syncJob.connector.filtering : null;
  const visible = !!syncJob;
  return visible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('searchConnectors.syncJobs.flyout.title', {
    defaultMessage: 'Event log'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sync_callouts.SyncJobCallouts, {
    syncJob: syncJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.sync', {
      defaultMessage: 'Sync'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: [{
      field: 'id',
      name: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.sync.id', {
        defaultMessage: 'ID'
      })
    }, {
      field: 'index_name',
      name: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.sync.index', {
        defaultMessage: 'Index name'
      })
    }],
    items: [{
      id: syncJob.id,
      index_name: syncJob.connector.index_name
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_documents_panel.SyncJobDocumentsPanel, {
    added: syncJob.indexed_document_count,
    removed: syncJob.deleted_document_count,
    volume: (_syncJob$indexed_docu = syncJob.indexed_document_volume) !== null && _syncJob$indexed_docu !== void 0 ? _syncJob$indexed_docu : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_events_panel.SyncJobEventsPanel, {
    canceledAt: (_syncJob$canceled_at = syncJob.canceled_at) !== null && _syncJob$canceled_at !== void 0 ? _syncJob$canceled_at : '',
    cancelationRequestedAt: (_syncJob$cancelation_ = syncJob.cancelation_requested_at) !== null && _syncJob$cancelation_ !== void 0 ? _syncJob$cancelation_ : '',
    syncRequestedAt: syncJob.created_at,
    syncStarted: (_syncJob$started_at = syncJob.started_at) !== null && _syncJob$started_at !== void 0 ? _syncJob$started_at : '',
    completed: (_syncJob$completed_at = syncJob.completed_at) !== null && _syncJob$completed_at !== void 0 ? _syncJob$completed_at : '',
    lastUpdated: (_syncJob$last_seen = syncJob.last_seen) !== null && _syncJob$last_seen !== void 0 ? _syncJob$last_seen : '',
    triggerMethod: syncJob.trigger_method,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_filtering_panel.FilteringPanel, {
    advancedSnippet: filtering === null || filtering === void 0 ? void 0 : filtering.advanced_snippet,
    filteringRules: (_filtering$rules = filtering === null || filtering === void 0 ? void 0 : filtering.rules) !== null && _filtering$rules !== void 0 ? _filtering$rules : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), ((_syncJob$connector = syncJob.connector) === null || _syncJob$connector === void 0 ? void 0 : _syncJob$connector.pipeline) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_panel.PipelinePanel, {
    pipeline: syncJob.connector.pipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.SyncJobFlyout = SyncJobFlyout;