"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportModeControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/import_mode_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createNewCopiesDisabled = {
  id: 'createNewCopiesDisabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledTitle', {
    defaultMessage: 'Check for existing objects'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledText', {
    defaultMessage: 'Check if objects were previously copied or imported.'
  })
};
const createNewCopiesEnabled = {
  id: 'createNewCopiesEnabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledTitle', {
    defaultMessage: 'Create new objects with random IDs'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledText', {
    defaultMessage: 'Use this option to create one or more copies of the object.'
  })
};
const overwriteEnabled = {
  id: 'overwriteEnabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.enabledLabel', {
    defaultMessage: 'Automatically overwrite conflicts'
  })
};
const overwriteDisabled = {
  id: 'overwriteDisabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.disabledLabel', {
    defaultMessage: 'Request action on conflict'
  })
};
const importOptionsTitle = _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.importOptionsTitle', {
  defaultMessage: 'Import options'
});
const createLabel = ({
  text,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 7
  }
}, text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltip,
  position: "left",
  type: "info",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 7
  }
})));
const ImportModeControl = ({
  initialValues,
  updateSelection
}) => {
  const [createNewCopies, setCreateNewCopies] = (0, _react.useState)(initialValues.createNewCopies);
  const [overwrite, setOverwrite] = (0, _react.useState)(initialValues.overwrite);
  const onChange = partial => {
    if (partial.createNewCopies !== undefined) {
      setCreateNewCopies(partial.createNewCopies);
    } else if (partial.overwrite !== undefined) {
      setOverwrite(partial.overwrite);
    }
    updateSelection({
      createNewCopies,
      overwrite,
      ...partial
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 13
        }
      }, importOptionsTitle))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesDisabled.id,
    label: createLabel(createNewCopiesDisabled),
    checked: !createNewCopies,
    onChange: () => onChange({
      createNewCopies: false
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "importModeOverwrite",
    options: [overwriteEnabled, overwriteDisabled],
    idSelected: overwrite ? overwriteEnabled.id : overwriteDisabled.id,
    onChange: id => onChange({
      overwrite: id === overwriteEnabled.id
    }),
    disabled: createNewCopies,
    "data-test-subj": 'savedObjectsManagement-importModeControl-overwriteRadioGroup',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesEnabled.id,
    label: createLabel(createNewCopiesEnabled),
    checked: createNewCopies,
    onChange: () => onChange({
      createNewCopies: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }));
};
exports.ImportModeControl = ImportModeControl;