"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/object_view/components/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Header = ({
  canDelete,
  canViewInApp,
  viewUrl,
  onDeleteClick,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: _i18n.i18n.translate('savedObjectsManagement.view.inspectItemTitle', {
      defaultMessage: 'Inspect {title}',
      values: {
        title: title || 'saved object'
      }
    }),
    rightSideItems: [canViewInApp && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      href: viewUrl,
      iconType: "eye",
      "data-test-subj": "savedObjectEditViewInApp",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.view.viewItemButtonLabel",
      defaultMessage: "View {title}",
      values: {
        title: title || 'saved object'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    })), canDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      size: "s",
      iconType: "trash",
      onClick: () => onDeleteClick(),
      "data-test-subj": "savedObjectEditDelete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.view.deleteItemButtonLabel",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
};
exports.Header = Header;