"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableState = tableState;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  filter: '',
  pageSize: 20,
  currentPage: 0,
  sortField: 'job.id',
  isSortAscending: true
};
function tableState(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.FILTER_CHANGED:
      const {
        filter
      } = payload;
      return {
        ...state,
        filter,
        currentPage: 0
      };
    case _action_types.SORT_CHANGED:
      const {
        sortField,
        isSortAscending
      } = payload;
      return {
        ...state,
        sortField,
        isSortAscending
      };
    case _action_types.PAGE_CHANGED:
      const {
        pageNumber
      } = payload;
      return {
        ...state,
        currentPage: pageNumber
      };
    case _action_types.PAGE_SIZE_CHANGED:
      const {
        pageSize
      } = payload;
      return {
        ...state,
        pageSize
      };
    default:
      return state;
  }
}