"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyDetectionJobsHealthRuleParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const anomalyDetectionJobsHealthRuleParamsSchema = exports.anomalyDetectionJobsHealthRuleParamsSchema = _configSchema.schema.object({
  includeJobs: _utils.jobsSelectionSchema,
  excludeJobs: _configSchema.schema.nullable(_utils.jobsSelectionSchema),
  testsConfig: _configSchema.schema.nullable(_configSchema.schema.object({
    datafeed: _configSchema.schema.nullable(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      })
    })),
    mml: _configSchema.schema.nullable(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      })
    })),
    delayedData: _configSchema.schema.nullable(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      }),
      docsCount: _configSchema.schema.nullable(_configSchema.schema.number({
        min: 1
      })),
      timeInterval: _configSchema.schema.nullable(_configSchema.schema.string())
    })),
    behindRealtime: _configSchema.schema.nullable(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      }),
      timeInterval: _configSchema.schema.nullable(_configSchema.schema.string())
    })),
    errorMessages: _configSchema.schema.nullable(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: true
      })
    }))
  }))
});