"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KIBANA_SOLUTIONS = exports.KIBANA_SECURITY_SOLUTION = exports.KIBANA_SECURITY_SEARCH_AI_LAKE_TIER = exports.KIBANA_SECURITY_ESSENTIALS_TIER = exports.KIBANA_SECURITY_COMPLETE_TIER = exports.KIBANA_SEARCH_SOLUTION = exports.KIBANA_PRODUCT_TIERS = exports.KIBANA_OBSERVABILITY_SOLUTION = exports.KIBANA_OBSERVABILITY_LOGS_ESSENTIALS_TIER = exports.KIBANA_OBSERVABILITY_COMPLETE_TIER = exports.KIBANA_CHAT_SOLUTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Constant for the Kibana Observability solution.
 */
const KIBANA_OBSERVABILITY_SOLUTION = exports.KIBANA_OBSERVABILITY_SOLUTION = 'observability';
/**
 * Constant for the Kibana Security solution.
 */
const KIBANA_SECURITY_SOLUTION = exports.KIBANA_SECURITY_SOLUTION = 'security';
/**
 * Constant for the Kibana Search solution.
 */
const KIBANA_SEARCH_SOLUTION = exports.KIBANA_SEARCH_SOLUTION = 'search';
/**
 * Constant for the Kibana Chat (workchat) solution.
 */
const KIBANA_CHAT_SOLUTION = exports.KIBANA_CHAT_SOLUTION = 'chat';

/**
 * A list of all Kibana solutions.
 */
const KIBANA_SOLUTIONS = exports.KIBANA_SOLUTIONS = [KIBANA_OBSERVABILITY_SOLUTION, KIBANA_SECURITY_SOLUTION, KIBANA_SEARCH_SOLUTION, KIBANA_CHAT_SOLUTION]; // BOOKMARK - List of Kibana solutions

/**
 * A type that defines the existing solutions.
 */

/**
 * Complete tier for Observability solution.
 */
const KIBANA_OBSERVABILITY_COMPLETE_TIER = exports.KIBANA_OBSERVABILITY_COMPLETE_TIER = 'complete';
/**
 * Logs Essentials tier for Observability solution.
 */
const KIBANA_OBSERVABILITY_LOGS_ESSENTIALS_TIER = exports.KIBANA_OBSERVABILITY_LOGS_ESSENTIALS_TIER = 'logs_essentials';
/**
 * Complete tier for Security solution.
 */
const KIBANA_SECURITY_COMPLETE_TIER = exports.KIBANA_SECURITY_COMPLETE_TIER = 'complete';
/**
 * Essentials tier for Security solution.
 */
const KIBANA_SECURITY_ESSENTIALS_TIER = exports.KIBANA_SECURITY_ESSENTIALS_TIER = 'essentials';
/**
 * Search AI Lake tier for Security solution.
 */
const KIBANA_SECURITY_SEARCH_AI_LAKE_TIER = exports.KIBANA_SECURITY_SEARCH_AI_LAKE_TIER = 'search_ai_lake';

/**
 * Possible product tiers for Kibana solutions.
 */
const KIBANA_PRODUCT_TIERS = exports.KIBANA_PRODUCT_TIERS = {
  [KIBANA_OBSERVABILITY_SOLUTION]: [KIBANA_OBSERVABILITY_COMPLETE_TIER, KIBANA_OBSERVABILITY_LOGS_ESSENTIALS_TIER],
  [KIBANA_SECURITY_SOLUTION]: [KIBANA_SECURITY_COMPLETE_TIER, KIBANA_SECURITY_ESSENTIALS_TIER, KIBANA_SECURITY_SEARCH_AI_LAKE_TIER],
  [KIBANA_SEARCH_SOLUTION]: [],
  [KIBANA_CHAT_SOLUTION]: []
};

/**
 * Existing product tiers for all Kibana solutions.
 */