"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalSamplesStat = TotalSamplesStat;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _label = require("./label");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/topn_functions/total_samples_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TotalSamplesStat({
  baselineTotalSamples,
  baselineScaleFactor,
  comparisonTotalSamples,
  comparisonScaleFactor
}) {
  const scaledBaselineTotalSamples = (0, _utils.scaleAndRoundValue)({
    value: baselineTotalSamples,
    scaleFactor: baselineScaleFactor
  });
  const value = scaledBaselineTotalSamples.toLocaleString();
  const sampleHeader = _i18n.i18n.translate('xpack.profiling.functionsView.totalSampleCountLabel', {
    defaultMessage: ' Total sample estimate: '
  });
  if (comparisonTotalSamples === undefined || comparisonTotalSamples === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        style: {
          fontWeight: 'bold'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 16
        }
      }, value),
      description: sampleHeader,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    });
  }
  const scaledComparisonTotalSamples = (0, _utils.scaleAndRoundValue)({
    value: comparisonTotalSamples,
    scaleFactor: comparisonScaleFactor
  });
  const diffSamples = scaledBaselineTotalSamples - scaledComparisonTotalSamples;
  const percentDelta = diffSamples / (scaledBaselineTotalSamples - diffSamples) * 100;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        fontWeight: 'bold'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, value, /*#__PURE__*/_react.default.createElement(_label.Label, {
      value: percentDelta,
      prepend: "(",
      append: ")",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    })),
    description: sampleHeader,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
}