"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActionResultsQuery = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../../../common/constants");
var _build_query = require("../../../../../utils/build_query");
var _build_index_name_with_namespace = require("../../../../../utils/build_index_name_with_namespace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildActionResultsQuery = ({
  actionId,
  kuery,
  startDate,
  sort,
  componentTemplateExists,
  useNewDataStream,
  integrationNamespaces
}) => {
  let filter = `action_id: ${actionId}`;
  if (!(0, _lodash.isEmpty)(kuery)) {
    filter = filter + ` AND ${kuery}`;
  }
  const timeRangeFilter = startDate && !(0, _lodash.isEmpty)(startDate) ? [{
    range: {
      started_at: {
        gte: startDate,
        lte: (0, _moment.default)(startDate).clone().add(30, 'minutes').toISOString()
      }
    }
  }] : [];
  const filterQuery = [...timeRangeFilter, (0, _build_query.getQueryFilter)({
    filter
  })];
  let baseIndex;
  if (useNewDataStream) {
    baseIndex = `${_constants.ACTION_RESPONSES_DATA_STREAM_INDEX}*`;
  } else if (componentTemplateExists) {
    baseIndex = `${_constants.ACTION_RESPONSES_INDEX}*`;
  } else {
    baseIndex = `${_common.AGENT_ACTIONS_RESULTS_INDEX}*`;
  }
  let index;
  if (integrationNamespaces && integrationNamespaces.length > 0) {
    index = integrationNamespaces.map(namespace => (0, _build_index_name_with_namespace.buildIndexNameWithNamespace)(baseIndex, namespace)).join(',');
  } else {
    index = baseIndex;
  }
  return {
    allow_no_indices: true,
    index,
    ignore_unavailable: true,
    aggs: {
      aggs: {
        global: {},
        aggs: {
          responses_by_action_id: {
            filter: {
              bool: {
                must: [{
                  match: {
                    action_id: actionId
                  }
                }]
              }
            },
            aggs: {
              rows_count: {
                sum: {
                  field: 'action_response.osquery.count'
                }
              },
              responses: {
                terms: {
                  script: {
                    lang: 'painless',
                    source: "if (doc['error.keyword'].size()==0) { return 'success' } else { return 'error' }"
                  }
                }
              }
            }
          }
        }
      }
    },
    query: {
      bool: {
        filter: filterQuery
      }
    },
    // from: activePage * querySize,
    size: 10000,
    // querySize,
    track_total_hits: true,
    fields: ['*'],
    sort: [{
      [sort.field]: {
        order: sort.direction
      }
    }]
  };
};
exports.buildActionResultsQuery = buildActionResultsQuery;