"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MainNavigation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _default = require("./layouts/default");
var _kibana = require("../common/lib/kibana");
var _manage_integration_link = require("./manage_integration_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/components/main_navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Section = /*#__PURE__*/function (Section) {
  Section["LiveQueries"] = "live_queries";
  Section["Packs"] = "packs";
  Section["SavedQueries"] = "saved_queries";
  return Section;
}(Section || {});
const MainNavigation = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const section = (0, _react.useMemo)(() => {
    var _location$pathname$sp;
    return (_location$pathname$sp = location.pathname.split('/')[1]) !== null && _location$pathname$sp !== void 0 ? _location$pathname$sp : 'overview';
  }, [location.pathname]);
  const feedbackButtonLabel = _i18n.i18n.translate('xpack.osquery.appNavigation.giveFeedbackButton', {
    defaultMessage: 'Give feedback'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _default.navCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    isSelected: section === Section.LiveQueries
  }, (0, _kibana.useRouterNavigate)(Section.LiveQueries), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.appNavigation.liveQueriesLinkText",
    defaultMessage: "Live queries",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    isSelected: section === Section.Packs
  }, (0, _kibana.useRouterNavigate)(Section.Packs), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.appNavigation.packsLinkText",
    defaultMessage: "Packs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    isSelected: section === Section.SavedQueries
  }, (0, _kibana.useRouterNavigate)(Section.SavedQueries), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.appNavigation.savedQueriesLinkText",
    defaultMessage: "Saved queries",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: "https://ela.st/osquery-feedback",
    target: "_blank",
    "aria-label": feedbackButtonLabel,
    iconType: "popout",
    iconSide: "right",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }, feedbackButtonLabel)), /*#__PURE__*/_react.default.createElement(_manage_integration_link.ManageIntegrationLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  })))));
};
exports.MainNavigation = MainNavigation;