"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationSections = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _group_conversations = require("../../../utils/group_conversations");
var _conversation_item = require("./conversation_item");
var _no_conversations_prompt = require("./no_conversations_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_sidebar/conversation_sections.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyStyles = (0, _react.css)`
  align-self: center;
  justify-content: center;
`;
const ConversationSections = ({
  conversations
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sectionTitleStyles = (0, _react.css)`
    margin-inline-start: ${euiTheme.size.s};
  `;
  const timeSections = (0, _react2.useMemo)(() => {
    if (!conversations || conversations.length === 0) {
      return [];
    }
    return (0, _group_conversations.groupConversationsByTime)(conversations);
  }, [conversations]);
  if (timeSections.length === 0) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      css: emptyStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_no_conversations_prompt.NoConversationsPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, timeSections.map(({
    label,
    conversations: sectionConversations
  }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: label,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: sectionTitleStyles,
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, label), /*#__PURE__*/_react2.default.createElement(_eui.EuiListGroup, {
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationSidebar.section', {
      defaultMessage: 'Conversations from {sectionLabel}',
      values: {
        sectionLabel: label
      }
    }),
    flush: true,
    "data-test-subj": "agentBuilderConversationList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, sectionConversations.map(conversation => /*#__PURE__*/_react2.default.createElement(_conversation_item.ConversationItem, {
    key: conversation.id,
    conversation: conversation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 17
    }
  })))))));
};
exports.ConversationSections = ConversationSections;