"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabularDataResultStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_onechat_service = require("../../../../../hooks/use_onechat_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/tabular_data_result_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TabularDataResultStep = ({
  result: {
    data
  }
}) => {
  const {
    startDependencies: {
      share
    }
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    url: {
      locators
    }
  } = share;
  const discoverLocator = (0, _react.useMemo)(() => locators.get('DISCOVER_APP_LOCATOR'), [locators]);
  const {
    query: esqlQuery
  } = data;
  const discoverUrl = (0, _react.useMemo)(() => {
    if (!esqlQuery) return undefined;
    return discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl({
      query: {
        esql: esqlQuery
      }
    });
  }, [discoverLocator, esqlQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversation.thinking.tabularDataResultStep.foundRecordsMessage",
    defaultMessage: "Found {results}",
    values: {
      results: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: discoverUrl,
        "data-test-subj": "onechat-esql-data-result-see-in-discover",
        "aria-label": _i18n.i18n.translate('xpack.onechat.conversation.thinking.tabularDataResultStep.seeInDiscoverAriaLabel', {
          defaultMessage: 'Explore results in Discover'
        }),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.onechat.conversation.thinking.tabularDataResultStep.foundRecordsMessage",
        defaultMessage: "{totalResults, plural, one {{totalResults, number} result} other {{totalResults, number} results}}",
        values: {
          totalResults: data.values.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  })));
};
exports.TabularDataResultStep = TabularDataResultStep;