"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAlertSummaryTimeRange = exports.getAlertSummaryTimeRange = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/data-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/utils/alert_summary_widget/get_alert_summary_time_range.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultAlertSummaryTimeRange = () => {
  const {
    to,
    from
  } = (0, _common.getAbsoluteTimeRange)(_constants.defaultTimeRange);
  return {
    utcFrom: from,
    utcTo: to,
    fixedInterval: '1d',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertsSummaryWidget.last30days",
      defaultMessage: "Last 30 days",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 7
      }
    })
  };
};
exports.getDefaultAlertSummaryTimeRange = getDefaultAlertSummaryTimeRange;
const getAlertSummaryTimeRange = (timeRange, fixedInterval, dateFormat) => {
  const {
    to,
    from
  } = (0, _common.getAbsoluteTimeRange)(timeRange);
  return {
    utcFrom: from,
    utcTo: to,
    fixedInterval,
    dateFormat
  };
};
exports.getAlertSummaryTimeRange = getAlertSummaryTimeRange;