"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsList = AnnotationsList;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _delete_annotations_modal = require("../../components/annotations/components/common/delete_annotations_modal");
var _use_delete_annotation = require("../../components/annotations/hooks/use_delete_annotation");
var _delete_annotations = require("../../components/annotations/components/common/delete_annotations");
var _use_annotation_permissions = require("../../components/annotations/hooks/use_annotation_permissions");
var _annotation_apply_to = require("./annotation_apply_to");
var _timestamp_range_label = require("../../components/annotations/components/timestamp_range_label");
var _date_picker = require("./date_picker");
var _annotations_list_chart = require("./annotations_list_chart");
var _use_fetch_annotations = require("../../components/annotations/hooks/use_fetch_annotations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/annotations/annotations_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AnnotationsList() {
  var _data$items$map$flat, _data$items, _data$items2, _data$items3;
  const {
    data: permissions
  } = (0, _use_annotation_permissions.useAnnotationPermissions)();
  const [selection, setSelection] = (0, _react.useState)([]);
  const [isEditing, setIsEditing] = (0, _react.useState)(null);
  const [start, setStart] = (0, _react.useState)('now-30d');
  const [end, setEnd] = (0, _react.useState)('now');
  const {
    data,
    isLoading,
    refetch
  } = (0, _use_fetch_annotations.useFetchAnnotations)({
    start,
    end
  });
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const {
    mutateAsync: deleteAnnotation,
    isLoading: isDeleteLoading
  } = (0, _use_delete_annotation.useDeleteAnnotation)();
  const onDelete = async deleteSelection => {
    if (deleteSelection) {
      await deleteAnnotation({
        annotations: [deleteSelection]
      });
    } else {
      await deleteAnnotation({
        annotations: selection
      });
      setSelection([]);
    }
    refetch();
  };
  const renderToolsLeft = () => {
    return /*#__PURE__*/_react.default.createElement(_delete_annotations.DeleteAnnotations, {
      key: "delete-annotations",
      selection: selection,
      isLoading: isDeleteLoading,
      permissions: permissions,
      setIsDeleteModalVisible: setIsDeleteModalVisible,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    });
  };
  const renderToolsRight = () => {
    return [/*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, {
      key: "date-picker",
      start: start,
      end: end,
      setStart: setStart,
      setEnd: setEnd,
      refetch: refetch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    })];
  };
  const allTags = (_data$items$map$flat = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : _data$items.map(obj => {
    var _obj$tags;
    return (_obj$tags = obj.tags) !== null && _obj$tags !== void 0 ? _obj$tags : [];
  }).flat()) !== null && _data$items$map$flat !== void 0 ? _data$items$map$flat : [];
  const search = {
    toolsLeft: renderToolsLeft(),
    toolsRight: renderToolsRight(),
    box: {
      incremental: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'tags',
      name: TAGS_LABEL,
      multiSelect: true,
      options: [...new Set(allTags)].map(tag => ({
        value: tag,
        name: tag
      }))
    }]
  };
  const pagination = {
    initialPageSize: 5,
    pageSizeOptions: [5, 10, 25, 50]
  };
  const selectionValue = {
    selectable: annot => true,
    onSelectionChange: annotSel => setSelection(annotSel),
    initialSelected: selection
  };
  const columns = [{
    field: 'annotation.title',
    name: TITLE_LABEL,
    sortable: true
  }, {
    field: '@timestamp',
    name: TIMESTAMP_LABEL,
    dataType: 'date',
    sortable: true,
    render: (timestamp, annotation) => {
      return /*#__PURE__*/_react.default.createElement(_timestamp_range_label.TimestampRangeLabel, {
        annotation: annotation,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 16
        }
      });
    }
  }, {
    field: 'message',
    name: MESSAGE_LABEL,
    sortable: true,
    truncateText: true
  }, {
    field: 'tags',
    name: TAGS_LABEL,
    render: tags => /*#__PURE__*/_react.default.createElement(_public.TagsList, {
      tags: tags,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 35
      }
    })
  }, {
    name: APPLY_TO_LABEL,
    render: annotation => {
      return /*#__PURE__*/_react.default.createElement(_annotation_apply_to.AnnotationApplyTo, {
        annotation: annotation,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 16
        }
      });
    }
  }, {
    actions: [{
      name: EDIT_LABEL,
      description: EDIT_LABEL,
      type: 'icon',
      icon: 'pencil',
      onClick: annotation => {
        setIsEditing(annotation);
      },
      enabled: () => {
        var _permissions$write;
        return (_permissions$write = permissions === null || permissions === void 0 ? void 0 : permissions.write) !== null && _permissions$write !== void 0 ? _permissions$write : false;
      }
    }, {
      name: DELETE_LABEL,
      description: DELETE_LABEL,
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: annotation => {
        setSelection([annotation]);
        setIsDeleteModalVisible(true);
      },
      enabled: () => {
        var _permissions$write2;
        return (_permissions$write2 = permissions === null || permissions === void 0 ? void 0 : permissions.write) !== null && _permissions$write2 !== void 0 ? _permissions$write2 : false;
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    childrenBetween: /*#__PURE__*/_react.default.createElement(_annotations_list_chart.AnnotationsListChart, {
      data: (_data$items2 = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items2 !== void 0 ? _data$items2 : [],
      start: start,
      end: end,
      isEditing: isEditing,
      setIsEditing: setIsEditing,
      permissions: permissions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }),
    tableCaption: _i18n.i18n.translate('xpack.observability.annotationsTableCaption', {
      defaultMessage: 'List of annotations for the selected time range.'
    }),
    items: (_data$items3 = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items3 !== void 0 ? _data$items3 : [],
    itemId: "id",
    loading: isLoading,
    columns: columns,
    search: search,
    pagination: pagination,
    sorting: true,
    selection: selectionValue,
    tableLayout: "auto",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_delete_annotations_modal.DeleteAnnotationsModal, {
    selection: selection,
    isDeleteModalVisible: isDeleteModalVisible,
    setSelection: setSelection,
    onDelete: onDelete,
    setIsDeleteModalVisible: setIsDeleteModalVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }));
}
const TITLE_LABEL = _i18n.i18n.translate('xpack.observability.titleLabel', {
  defaultMessage: 'Title'
});
const APPLY_TO_LABEL = _i18n.i18n.translate('xpack.observability.applyTo', {
  defaultMessage: 'Apply to'
});
const EDIT_LABEL = _i18n.i18n.translate('xpack.observability.editAnnotation', {
  defaultMessage: 'Edit'
});
const DELETE_LABEL = _i18n.i18n.translate('xpack.observability.deleteAnnotation', {
  defaultMessage: 'Delete'
});
const TAGS_LABEL = _i18n.i18n.translate('xpack.observability.tagsAnnotations', {
  defaultMessage: 'Tags'
});
const MESSAGE_LABEL = _i18n.i18n.translate('xpack.observability.messageAnnotations', {
  defaultMessage: 'Message'
});
const TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.observability.timestampAnnotations', {
  defaultMessage: 'Timestamp'
});