"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverUrl = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _kibana_react = require("../../../../utils/kibana_react");
var _synthetics_alert_params_to_kql = require("./synthetics_alert_params_to_kql");
var _get_rule_data = require("./get_rule_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const viewInDiscoverSupportedRuleTypes = [_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.SYNTHETICS_STATUS_RULE, _ruleDataUtils.SYNTHETICS_TLS_RULE, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID];
const isViewInDiscoverSupportedRuleType = ruleTypeId => {
  return ruleTypeId !== undefined && Object.values(viewInDiscoverSupportedRuleTypes).includes(ruleTypeId);
};
const SYNTHETICS_TEMP_DATA_VIEW = {
  title: 'synthetics-*',
  timeFieldName: '@timestamp'
};
/**
 * For certain rule types, we create a temporary data view.
 * Otherwise, returns undefined, and an existing saved data view must be specified.
 * @param rule an Observability alerting rule
 * @returns A temporary data view spec, or undefined
 */
const getCustomDataViewParams = rule => {
  switch (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) {
    case _ruleDataUtils.SYNTHETICS_TLS_RULE:
    case _ruleDataUtils.SYNTHETICS_STATUS_RULE:
      return SYNTHETICS_TEMP_DATA_VIEW;
    default:
      return undefined;
  }
};
const getLocatorParamsMap = {
  [_ruleDataUtils.SYNTHETICS_STATUS_RULE]: ({
    rule
  }) => {
    const params = rule.params;
    const query = (0, _synthetics_alert_params_to_kql.syntheticsMonitorStatusAlertParamsToKqlQuery)(params);
    return {
      discoverAppLocatorParams: {
        query: {
          language: 'kuery',
          query
        },
        dataViewSpec: getCustomDataViewParams(rule)
      }
    };
  },
  [_ruleDataUtils.SYNTHETICS_TLS_RULE]: ({
    rule
  }) => {
    const params = rule.params;
    const query = (0, _synthetics_alert_params_to_kql.syntheticsTlsAlertParamsToKqlQuery)(params);
    return {
      discoverAppLocatorParams: {
        query: {
          language: 'kuery',
          query
        },
        dataViewSpec: getCustomDataViewParams(rule)
      }
    };
  },
  [_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID]: _get_rule_data.getCustomThresholdRuleData,
  [_ruleDataUtils.ES_QUERY_ID]: _get_rule_data.getEsQueryRuleData,
  [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID]: _get_rule_data.getSLOBurnRateRuleData
};
const useDiscoverUrl = ({
  alert,
  rule
}) => {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    discover
  } = services;
  const {
    discoverUrl,
    discoverAppLocatorParams
  } = isViewInDiscoverSupportedRuleType(rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) && alert ? getLocatorParamsMap[rule.ruleTypeId]({
    rule,
    alert
  }) : {
    discoverUrl: undefined,
    discoverAppLocatorParams: undefined
  };
  if (discoverUrl) return {
    discoverUrl
  };
  if (discoverAppLocatorParams && discover !== null && discover !== void 0 && discover.locator && alert) return {
    discoverUrl: discover.locator.getRedirectUrl({
      ...discoverAppLocatorParams,
      timeRange: {
        from: (0, _moment.default)(alert.start).subtract(30, 'minutes').toISOString(),
        to: (0, _moment.default)(alert.start).add(30, 'minutes').toISOString()
      }
    })
  };
  return {
    discoverUrl: null
  };
};
exports.useDiscoverUrl = useDiscoverUrl;