"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _serverRouteRepository = require("@kbn/server-route-repository");
var _routes = require("./routes");
var _observability_onboarding_status = require("./saved_objects/observability_onboarding_status");
var _es_legacy_config_service = require("./services/es_legacy_config_service");
var _telemetry_events = require("../common/telemetry_events");
var _pricing_features = require("../common/pricing_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityOnboardingPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "esLegacyConfigService", new _es_legacy_config_service.EsLegacyConfigService());
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = this.initContext.logger.get();
  }
  setup(core, plugins) {
    var _core$http$staticAsse;
    this.esLegacyConfigService.setup(core.elasticsearch.legacy.config$);
    core.savedObjects.registerType(_observability_onboarding_status.observabilityOnboardingFlow);
    const resourcePlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const config = this.initContext.config.get();
    const dependencies = {
      config,
      kibanaVersion: this.initContext.env.packageInfo.version,
      plugins: resourcePlugins,
      services: {
        esLegacyConfigService: this.esLegacyConfigService
      },
      core: {
        setup: core,
        start: () => core.getStartServices().then(([coreStart]) => coreStart)
      }
    };
    (0, _serverRouteRepository.registerRoutes)({
      core,
      logger: this.logger,
      repository: (0, _routes.getObservabilityOnboardingServerRouteRepository)(),
      dependencies,
      runDevModeChecks: this.initContext.env.mode.dev
    });
    plugins.customIntegrations.registerCustomIntegration({
      id: 'otel',
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelTile.title', {
        defaultMessage: 'OpenTelemetry'
      }),
      categories: ['observability'],
      uiInternalPath: '/app/observabilityOnboarding/otel-logs',
      description: _i18n.i18n.translate('xpack.observability_onboarding.otelTile.description', {
        defaultMessage: 'Collect logs and host metrics using the Elastic distribution of the OpenTelemetry Collector'
      }),
      icons: [{
        type: 'svg',
        src: (_core$http$staticAsse = core.http.staticAssets.getPluginAssetHref('opentelemetry.svg')) !== null && _core$http$staticAsse !== void 0 ? _core$http$staticAsse : ''
      }],
      shipper: 'tutorial',
      isBeta: true
    });
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT);
    core.pricing.registerProductFeatures([{
      id: _pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING,
      description: 'Enables flows that onboard metrics. This feature is available only in the "complete" tier.',
      products: [{
        name: 'observability',
        tier: 'complete'
      }]
    }]);
    return {};
  }
  start(core) {
    return {};
  }
  stop() {
    this.esLegacyConfigService.stop();
  }
}
exports.ObservabilityOnboardingPlugin = ObservabilityOnboardingPlugin;