"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseEditManualEntryFlyout = KnowledgeBaseEditManualEntryFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _uuid = require("uuid");
var _use_create_knowledge_base_entry = require("../../hooks/use_create_knowledge_base_entry");
var _use_delete_knowledge_base_entry = require("../../hooks/use_delete_knowledge_base_entry");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/knowledge_base_edit_manual_entry_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function KnowledgeBaseEditManualEntryFlyout({
  entry,
  onClose
}) {
  var _entry$public, _entry$title, _entry$text;
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const dateFormat = uiSettings.get('dateFormat');
  const {
    mutateAsync: createEntry,
    isLoading
  } = (0, _use_create_knowledge_base_entry.useCreateKnowledgeBaseEntry)();
  const {
    mutateAsync: deleteEntry,
    isLoading: isDeleting
  } = (0, _use_delete_knowledge_base_entry.useDeleteKnowledgeBaseEntry)();
  const [isPublic, setIsPublic] = (0, _react.useState)((_entry$public = entry === null || entry === void 0 ? void 0 : entry.public) !== null && _entry$public !== void 0 ? _entry$public : false);
  const [newEntryTitle, setNewEntryTitle] = (0, _react.useState)((_entry$title = entry === null || entry === void 0 ? void 0 : entry.title) !== null && _entry$title !== void 0 ? _entry$title : '');
  const [newEntryText, setNewEntryText] = (0, _react.useState)((_entry$text = entry === null || entry === void 0 ? void 0 : entry.text) !== null && _entry$text !== void 0 ? _entry$text : '');
  const isEntryTitleInvalid = newEntryTitle.trim() === '';
  const isEntryTextInvalid = newEntryText.trim() === '';
  const isFormInvalid = isEntryTitleInvalid || isEntryTextInvalid;
  const handleSubmit = async () => {
    var _entry$id;
    await createEntry({
      entry: {
        id: (_entry$id = entry === null || entry === void 0 ? void 0 : entry.id) !== null && _entry$id !== void 0 ? _entry$id : (0, _uuid.v4)(),
        title: newEntryTitle,
        text: newEntryText,
        public: isPublic,
        role: _public.KnowledgeBaseEntryRole.UserEntry,
        labels: {}
      }
    });
    onClose();
  };
  const handleDelete = async () => {
    await deleteEntry({
      id: entry.id
    });
    onClose();
  };
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "knowledgeBaseManualEntryFlyout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, !entry ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewEntryFlyout.h2.newEntryLabel', {
    defaultMessage: 'New entry'
  }) : _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewEntryFlyout.h2.editEntryLabel', {
    defaultMessage: 'Edit {title}',
    values: {
      title: entry === null || entry === void 0 ? void 0 : entry.title
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, entry ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.createdOnTextLabel', {
    defaultMessage: 'Created on'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, (0, _moment.default)(entry['@timestamp']).format(dateFormat))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutDeleteEntryButton",
    color: "danger",
    iconType: "trash",
    isLoading: isDeleting,
    onClick: handleDelete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.deleteEntryButtonLabel', {
    defaultMessage: 'Delete entry'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiFormRow.idLabel', {
      defaultMessage: 'Name'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutIdInput",
    fullWidth: true,
    value: newEntryTitle,
    onChange: e => setNewEntryTitle(e.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiButtonGroup.visibilityLabel', {
      defaultMessage: 'Visibility'
    }),
    options: [{
      id: 'user',
      label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiButtonGroup.userLabel', {
        defaultMessage: 'User'
      })
    }, {
      id: 'global',
      label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiButtonGroup.globalLabel', {
        defaultMessage: 'Global'
      })
    }],
    idSelected: isPublic ? 'global' : 'user',
    onChange: optionId => setIsPublic(optionId === 'global'),
    buttonSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: "Global entries will be available to all users. User entries will only be available to the author.",
    position: "top",
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiFormRow.contentsLabel', {
      defaultMessage: 'Contents'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    editorId: "knowledgeBaseEditManualEntryFlyoutMarkdownEditor",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.euiMarkdownEditor.observabilityAiAssistantKnowledgeBaseViewMarkdownEditorLabel', {
      defaultMessage: 'observabilityAiAssistantKnowledgeBaseViewMarkdownEditor'
    }),
    height: 300,
    initialViewMode: "editing",
    readOnly: false,
    placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiMarkdownEditor.enterContentsLabel', {
      defaultMessage: 'Enter contents'
    }),
    value: newEntryText,
    onChange: text => setNewEntryText(text),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutCancelButton",
    disabled: isLoading,
    onClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutSaveButton",
    fill: true,
    isLoading: isLoading,
    onClick: handleSubmit,
    isDisabled: isFormInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}