"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseBulkImportFlyout = KnowledgeBaseBulkImportFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_import_knowledge_base_entries = require("../../hooks/use_import_knowledge_base_entries");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/knowledge_base_bulk_import_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function KnowledgeBaseBulkImportFlyout({
  onClose
}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    mutateAsync,
    isLoading
  } = (0, _use_import_knowledge_base_entries.useImportKnowledgeBaseEntries)();
  const filePickerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filePicker'
  });
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const [files, setFiles] = (0, _react.useState)([]);
  const onChange = file => {
    setFiles(file && file.length > 0 ? Array.from(file) : []);
  };
  const handleSubmitNewEntryClick = async () => {
    const text = await files[0].text();
    const elements = text.split('\n').filter(Boolean);
    try {
      const entries = elements.map(el => JSON.parse(el));
      await mutateAsync({
        entries
      });
    } catch (_) {
      toasts.addError(new Error(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.errorParsingEntries.description', {
        defaultMessage: 'Error parsing JSON entries'
      })), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.errorParsingEntries.title', {
          defaultMessage: 'Something went wrong'
        })
      });
    }
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "knowledgeBaseBulkImportFlyout",
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.h2.bulkImportLabel', {
    defaultMessage: 'Import files'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "addDataApp",
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.addFilesToEnrichTitleLabel', {
    defaultMessage: 'Add files to enrich your Knowledge base'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.uploadAJSONFileTextLabel",
    defaultMessage: "Upload a newline delimited JSON ({ext}) file containing a list of entries to add to your Knowledge base.",
    values: {
      ext: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        language: "html",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 20
        }
      }, ".ndjson")
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.theObjectsShouldBeTextLabel', {
    defaultMessage: 'The objects should be of the following format:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, JSON.stringify({
    id: 'some_uuid',
    title: 'Title of item',
    text: 'Contents of item'
  }), `\n`, JSON.stringify({
    id: 'a_different_uuid',
    title: 'Title of second item',
    text: 'Contents of second item'
  }), `\n`, JSON.stringify({
    id: 'another_uuid',
    title: 'Title of third item',
    text: 'Contents of third item'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.euiFilePicker.uploadJSONLabel', {
      defaultMessage: 'Upload JSON'
    }),
    display: "large",
    fullWidth: true,
    id: filePickerId,
    initialPromptText: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.euiFilePicker.selectOrDragAndLabel', {
      defaultMessage: 'Select or drag and drop a .ndjson file'
    }),
    onChange: onChange,
    accept: ".ndjson",
    "data-test-subj": "knowledgeBaseBulkImportFilePicker",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseBulkImportFlyoutCancelButton",
    disabled: isLoading,
    onClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseBulkImportFlyoutSaveButton",
    fill: true,
    isLoading: isLoading,
    disabled: files.length === 0,
    onClick: handleSubmitNewEntryClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseBulkImportFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}