"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesType = void 0;
exports.registerLensRenderFunction = registerLensRenderFunction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/functions/lens.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let SeriesType = exports.SeriesType = /*#__PURE__*/function (SeriesType) {
  SeriesType["Bar"] = "bar";
  SeriesType["Line"] = "line";
  SeriesType["Area"] = "area";
  SeriesType["BarStacked"] = "bar_stacked";
  SeriesType["AreaStacked"] = "area_stacked";
  SeriesType["BarHorizontal"] = "bar_horizontal";
  SeriesType["BarPercentageStacked"] = "bar_percentage_stacked";
  SeriesType["AreaPercentageStacked"] = "area_percentage_stacked";
  SeriesType["BarHorizontalPercentageStacked"] = "bar_horizontal_percentage_stacked";
  return SeriesType;
}({});
function Lens({
  indexPattern,
  xyDataLayer,
  start,
  end,
  lens,
  dataViews,
  timeField
}) {
  const dataViewAsync = (0, _useAsync.default)(() => {
    return dataViews.create({
      title: indexPattern,
      timeFieldName: timeField
    });
  }, [indexPattern, dataViews, timeField]);
  const [isSaveModalOpen, setIsSaveModalOpen] = (0, _react.useState)(false);
  if (!dataViewAsync.value) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  const attributes = new _lensEmbeddableUtils.LensAttributesBuilder({
    visualization: new _lensEmbeddableUtils.XYChart({
      layers: [xyDataLayer],
      dataView: dataViewAsync.value
    })
  }).build();
  const lensEmbeddableInput = {
    id: indexPattern,
    attributes,
    timeRange: {
      from: start,
      to: end,
      mode: 'relative'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantLensOpenInLensButton",
    iconType: "lensApp",
    onClick: () => {
      lens.navigateToPrefilledEditor(lensEmbeddableInput);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensFunction.openInLens', {
    defaultMessage: 'Open in Lens'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantLensSaveButton",
    iconType: "save",
    onClick: () => {
      setIsSaveModalOpen(() => true);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensFunction.save', {
    defaultMessage: 'Save'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensEmbeddableInput, {
    style: {
      height: 240
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })))), isSaveModalOpen ? /*#__PURE__*/_react.default.createElement(lens.SaveModalComponent, {
    initialInput: lensEmbeddableInput,
    onClose: () => {
      setIsSaveModalOpen(() => false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }) : null);
}
function registerLensRenderFunction({
  registerRenderFunction,
  pluginsStart
}) {
  registerRenderFunction('lens', ({
    arguments: {
      layers,
      indexPattern,
      breakdown,
      seriesType,
      start,
      end,
      timeField
    }
  }) => {
    const xyDataLayer = new _lensEmbeddableUtils.XYDataLayer({
      data: layers.map(layer => {
        var _layer$filter;
        return {
          type: 'formula',
          value: layer.formula,
          label: layer.label,
          format: layer.format,
          filter: {
            language: 'kql',
            query: (_layer$filter = layer.filter) !== null && _layer$filter !== void 0 ? _layer$filter : ''
          }
        };
      }),
      options: {
        seriesType,
        breakdown: breakdown ? {
          type: 'top_values',
          params: {
            size: 10
          },
          field: breakdown.field
        } : undefined
      }
    });
    if (!timeField) return;
    return /*#__PURE__*/_react.default.createElement(Lens, {
      indexPattern: indexPattern,
      xyDataLayer: xyDataLayer,
      start: start,
      end: end,
      lens: pluginsStart.lens,
      dataViews: pluginsStart.dataViews,
      timeField: timeField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    });
  });
}