"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusIcon = exports.STATUS_ICON_TYPES = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/status_icon/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const STATUS_ICON_TYPES = exports.STATUS_ICON_TYPES = {
  RED: 'RED',
  YELLOW: 'YELLOW',
  GREEN: 'GREEN',
  GRAY: 'GRAY'
};
const typeToIconMap = {
  [STATUS_ICON_TYPES.RED]: 'danger',
  [STATUS_ICON_TYPES.YELLOW]: 'warning',
  [STATUS_ICON_TYPES.GREEN]: 'success',
  [STATUS_ICON_TYPES.GRAY]: 'subdued'
};
const StatusIcon = ({
  type,
  label
}) => {
  const icon = typeToIconMap[type];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon
  // @ts-ignore
  , {
    alt: label,
    size: "l",
    "data-test-subj": "statusIcon",
    type: "dot",
    color: icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
};
exports.StatusIcon = StatusIcon;