"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CcrShard = CcrShard;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _chart = require("../../chart");
var _status = require("./status");
var _formatting = require("../../../../common/formatting");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _callout = require("../../../alerts/callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/ccr_shard/ccr_shard.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CcrShard(props) {
  var _services$uiSettings;
  const {
    services
  } = (0, _public.useKibana)();
  const timezone = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get('dateFormat:tz');
  const {
    metrics,
    stat,
    timestamp,
    oldestStat,
    formattedLeader,
    alerts
  } = props;
  const renderCharts = () => {
    const seriesToShow = [metrics.ccr_sync_lag_ops, metrics.ccr_sync_lag_time];
    const charts = seriesToShow.map((data, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minWidth: '45%'
      },
      key: index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
      series: data,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 11
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    }, charts);
  };
  const renderErrors = () => {
    if (stat.read_exceptions && stat.read_exceptions.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.ccrShard.errorsTableTitle",
        defaultMessage: "Errors",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        items: stat.read_exceptions,
        columns: [{
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.errorsTable.typeColumnTitle', {
            defaultMessage: 'Type'
          }),
          field: 'exception.type'
        }, {
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.errorsTable.reasonColumnTitle', {
            defaultMessage: 'Reason'
          }),
          field: 'exception.reason',
          width: '75%'
        }],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      }));
    }
    return null;
  };
  const renderLatestStat = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "ccrLatestStat",
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.ccrShard.latestStateAdvancedButtonLabel",
        defaultMessage: "Advanced",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      }))),
      paddingSize: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }, (0, _formatting.formatDateTimeLocal)(timestamp, timezone))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, JSON.stringify(stat, null, 2))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status.Status, {
    stat: stat,
    formattedLeader: formattedLeader,
    oldestStat: oldestStat,
    alerts: alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_callout.AlertsCallout, {
    alerts: alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), renderErrors(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, renderCharts()), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), renderLatestStat()));
}