"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmOverviewPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _apm_template = require("./apm_template");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _overview = require("../../../components/apm/overview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/apm/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ApmOverviewPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)(null);
  const title = _i18n.i18n.translate('xpack.monitoring.apm.overview.routeTitle', {
    defaultMessage: 'APM server'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.apm.overview.pageTitle', {
    defaultMessage: 'APM server overview'
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inApm: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/apm`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData(response);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_apm_template.ApmTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "apmOverviewPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  },
  // @ts-expect-error ts upgrade v4.7.4
  data && /*#__PURE__*/_react.default.createElement(_overview.ApmOverview, (0, _extends2.default)({}, data, {
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  })));
};
exports.ApmOverviewPage = ApmOverviewPage;