"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFilterListToolbar = EditFilterListToolbar;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _add_item_popover = require("../components/add_item_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/filter_lists/edit/toolbar.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for the toolbar section of the edit filter list page,
 * holding a search bar, and buttons for adding and deleting items from the list.
 */
function renderToolsRight(canCreateFilter, canDeleteFilter, addItems, deleteSelectedItems, selectedItemCount) {
  return [/*#__PURE__*/_react.default.createElement(_add_item_popover.AddItemPopover, {
    addItems: addItems,
    canCreateFilter: canCreateFilter,
    key: "add_item_btn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    size: "s",
    disabled: selectedItemCount === 0 || canDeleteFilter === false,
    onClick: deleteSelectedItems,
    key: "delete_item_btn",
    "data-test-subj": "mlFilterListDeleteItemButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.toolbar.deleteItemButtonLabel",
    defaultMessage: "Delete item",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }))];
}
function EditFilterListToolbar({
  canCreateFilter,
  canDeleteFilter,
  onSearchChange,
  addItems,
  deleteSelectedItems,
  selectedItemCount
}) {
  const toolsRight = renderToolsRight(canCreateFilter, canDeleteFilter, addItems, deleteSelectedItems, selectedItemCount);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    toolsRight: toolsRight,
    onChange: onSearchChange,
    filters: [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }))));
}
EditFilterListToolbar.propTypes = {
  canCreateFilter: _propTypes.default.bool.isRequired,
  canDeleteFilter: _propTypes.default.bool.isRequired,
  onSearchChange: _propTypes.default.func.isRequired,
  addItems: _propTypes.default.func.isRequired,
  deleteSelectedItems: _propTypes.default.func.isRequired,
  selectedItemCount: _propTypes.default.number.isRequired
};