"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ANIMATION_SWITCH_DELAY_MS = void 0;
exports.useAnimateSplit = useAnimateSplit;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANIMATION_SWITCH_DELAY_MS = exports.ANIMATION_SWITCH_DELAY_MS = 1000;

// custom hook to enable the card split animation of the cards 1 second after the component has been rendered
// then switching to a step which contains the cards, the animation shouldn't play, instead
// the cards should be initially rendered in the split state.
// all subsequent changes to the split should be animated.

function useAnimateSplit() {
  const [animateSplit, setAnimateSplit] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      setAnimateSplit(true);
    }, ANIMATION_SWITCH_DELAY_MS);
  }, []);
  return animateSplit;
}