"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobInfoFlyouts = exports.JobInfoFlyoutsProvider = exports.JobInfoFlyoutsContext = exports.FlyoutType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/components/job_details_flyout/job_details_flyout_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let FlyoutType = exports.FlyoutType = /*#__PURE__*/function (FlyoutType) {
  FlyoutType["JOB_DETAILS"] = "jobDetails";
  FlyoutType["DATAFEED_CHART"] = "datafeedChart";
  FlyoutType["DATA_FRAME_ANALYTICS_DETAILS"] = "dataFrameAnalyticsDetails";
  return FlyoutType;
}({});
const JobInfoFlyoutsContext = exports.JobInfoFlyoutsContext = /*#__PURE__*/(0, _react.createContext)({
  activeJobId: null,
  setActiveJobId: () => {},
  activeFlyout: null,
  setActiveFlyout: () => {},
  isDetailFlyoutOpen: false,
  isDatafeedChartFlyoutOpen: false,
  closeActiveFlyout: () => {},
  isDataFrameAnalyticsDetailsFlyoutOpen: false
});
const useJobInfoFlyouts = () => (0, _react.useContext)(JobInfoFlyoutsContext);
exports.useJobInfoFlyouts = useJobInfoFlyouts;
const JobInfoFlyoutsProvider = ({
  children
}) => {
  const [activeJobId, setActiveJobId] = (0, _react.useState)(null);
  const [activeFlyout, setActiveFlyout] = (0, _react.useState)(null);
  const isDetailFlyoutOpen = (0, _react.useMemo)(() => activeFlyout === FlyoutType.JOB_DETAILS, [activeFlyout]);
  const isDatafeedChartFlyoutOpen = (0, _react.useMemo)(() => activeFlyout === FlyoutType.DATAFEED_CHART, [activeFlyout]);
  const isDataFrameAnalyticsDetailsFlyoutOpen = (0, _react.useMemo)(() => activeFlyout === FlyoutType.DATA_FRAME_ANALYTICS_DETAILS, [activeFlyout]);
  const closeActiveFlyout = (0, _react.useCallback)(() => {
    setActiveJobId(null);
    setActiveFlyout(null);
  }, [setActiveJobId, setActiveFlyout]);
  return /*#__PURE__*/_react.default.createElement(JobInfoFlyoutsContext.Provider, {
    value: {
      activeJobId,
      setActiveJobId,
      isDetailFlyoutOpen,
      isDatafeedChartFlyoutOpen,
      isDataFrameAnalyticsDetailsFlyoutOpen,
      setActiveFlyout,
      activeFlyout,
      closeActiveFlyout
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, children);
};
exports.JobInfoFlyoutsProvider = JobInfoFlyoutsProvider;