"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIdSelectorControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_details_flyout_context = require("../../../../jobs/components/job_details_flyout/job_details_flyout_context");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/components/analytics_selector/analytics_id_selector_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectorControl = ({
  analyticsId,
  'data-test-subj': dataTestSubj
}) => {
  const {
    setActiveJobId,
    setActiveFlyout
  } = (0, _job_details_flyout_context.useJobInfoFlyouts)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: [{
        name: _i18n.i18n.translate('xpack.ml.overview.dataFrameAnalytics.jobContextMenu.details', {
          defaultMessage: 'Job details'
        }),
        icon: 'eye',
        'data-test-subj': `mlAnalyticsJobDetailsFlyoutButton-${analyticsId}`,
        onClick: () => {
          setActiveJobId(analyticsId);
          setActiveFlyout(_job_details_flyout_context.FlyoutType.DATA_FRAME_ANALYTICS_DETAILS);
          closePopover();
        }
      }]
    }];
  }, [analyticsId, closePopover, setActiveFlyout, setActiveJobId]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": dataTestSubj,
    iconType: "boxesVertical",
    iconSide: "right",
    onClick: setIsPopoverOpen.bind(null, true),
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, analyticsId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `mlAnalyticsDetailsPopover ${analyticsId}`,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
const AnalyticsIdSelectorControls = ({
  setIsIdSelectorFlyoutVisible,
  selectedId
}) => {
  const [canGetDataFrameAnalytics, canCreateDataFrameAnalytics] = (0, _check_capabilities.usePermissionCheck)(['canGetDataFrameAnalytics', 'canCreateDataFrameAnalytics']);
  const redirectToDfaJobManagement = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'analytics');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, selectedId ? /*#__PURE__*/_react.default.createElement(SelectorControl, {
    key: `${selectedId}-id`,
    "data-test-subj": `mlAnalyticsIdSelectionBadge-${selectedId}`,
    analyticsId: selectedId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }) : null, !selectedId ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.noIdsSelectedLabel",
    defaultMessage: "No Analytics ID selected",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "pencil",
    onClick: setIsIdSelectorFlyoutVisible.bind(null, true),
    "data-test-subj": "mlButtonEditAnalyticsIdSelection",
    "aria-label": _i18n.i18n.translate('xpack.ml.overview.dataFrameAnalytics.analyticsIdSelector.editSelectionForAriaLabel', {
      defaultMessage: 'Edit selection for {id}',
      values: {
        id: selectedId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.editSelection",
    defaultMessage: "Edit selection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), canGetDataFrameAnalytics ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "primary",
    onClick: redirectToDfaJobManagement,
    disabled: !canGetDataFrameAnalytics,
    "data-test-subj": "mlJobSelectorManageJobsButton",
    "aria-label": _i18n.i18n.translate('xpack.ml.overview.dataFrameAnalytics.jobSelector.manageJobsForAriaLabel', {
      defaultMessage: 'Manage jobs'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, canCreateDataFrameAnalytics ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobSelector.manageJobsLinkLabel",
    defaultMessage: "Manage jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobSelector.viewJobsLinkLabel",
    defaultMessage: "View jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }));
};
exports.AnalyticsIdSelectorControls = AnalyticsIdSelectorControls;