"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobSelection = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../contexts/kibana");
var _use_job_selection_flyout = require("../../contexts/ml/use_job_selection_flyout");
var _anomaly_explorer_context = require("../../explorer/anomaly_explorer_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useJobSelection = jobs => {
  const {
    toasts: toastNotifications
  } = (0, _kibana.useNotifications)();
  const {
    anomalyExplorerCommonStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const selectedJobs = (0, _useObservable.default)(anomalyExplorerCommonStateService.selectedJobs$, anomalyExplorerCommonStateService.selectedJobs);
  const invalidJobIds = (0, _useObservable.default)(anomalyExplorerCommonStateService.invalidJobIds$, anomalyExplorerCommonStateService.invalidJobIds);
  const getJobSelection = (0, _use_job_selection_flyout.useJobSelectionFlyout)();
  const selectedIds = (0, _react.useMemo)(() => {
    return selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.map(j => j.id);
  }, [selectedJobs]);
  (0, _react.useEffect)(() => {
    if (invalidJobIds.length > 0) {
      toastNotifications.addWarning(_i18n.i18n.translate('xpack.ml.jobSelect.requestedJobsDoesNotExistWarningMessage', {
        defaultMessage: `Requested
  {invalidIdsLength, plural, one {job {invalidIds} does not exist} other {jobs {invalidIds} do not exist}}`,
        values: {
          invalidIdsLength: invalidJobIds.length,
          invalidIds: invalidJobIds.join()
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [invalidJobIds]);
  (0, _react.useEffect)(() => {
    // if there are no valid ids, ask the user to provide job selection with the flyout
    if (!selectedIds || selectedIds.length === 0 && jobs.length > 0) {
      getJobSelection({
        singleSelection: false
      }).then(({
        jobIds,
        time
      }) => {
        anomalyExplorerCommonStateService.setSelectedJobs(jobIds, time);
      }).catch(() => {
        // flyout closed without selection
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobs]);
  return {
    selectedIds,
    selectedJobs
  };
};
exports.useJobSelection = useJobSelection;