"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractMetricFields = extractMetricFields;
var _iterate_field_caps_generator = require("./iterate_field_caps_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractMetricFields(fields) {
  const timeSeriesFields = [];
  for (const currentTimeSeriesFields of (0, _iterate_field_caps_generator.getTimeSeriesFieldCapsGenerator)(fields, {
    batchSize: 500
  })) {
    if (currentTimeSeriesFields.length > 0) {
      timeSeriesFields.push(...currentTimeSeriesFields.map(f => ({
        ...f,
        fieldType: 'metric'
      })));
    }
  }
  return timeSeriesFields;
}