"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoRemoteCluster = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _no_indices = require("./no_indices");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/metrics_data_access/public/components/empty_states/no_remote_cluster.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NoRemoteCluster = () => {
  const settingLinkProps = (0, _public.useLinkProps)({
    app: 'metrics',
    pathname: '/settings'
  });
  const goToSettings = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "infraHostsPageGoToSettings",
    color: "danger"
  }, settingLinkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }), _i18n.i18n.translate('xpack.metricsData.hostsPage.goToMetricsSettings', {
    defaultMessage: 'Check settings'
  }));
  return /*#__PURE__*/_react.default.createElement(_no_indices.NoIndices, {
    color: "danger",
    iconType: "error",
    titleSize: "m",
    "data-test-subj": "infraHostsNoRemoteCluster",
    title: _i18n.i18n.translate('xpack.metricsData.sourceConfiguration.noRemoteClusterTitle', {
      defaultMessage: "Couldn't connect to the remote cluster"
    }),
    body: _i18n.i18n.translate('xpack.metricsData.sourceConfiguration.noRemoteClusterMessage', {
      defaultMessage: "We're unable to connect to the remote cluster, which is preventing us from retrieving the metrics and data you need.\nTo resolve this issue, please check your indices configuration and ensure that it's properly configured."
    }),
    actions: [goToSettings],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
};
exports.NoRemoteCluster = NoRemoteCluster;