"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScalingForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
var _constants = require("../../../../../common/constants");
var _load_index_settings = require("./load_index_settings");
var _scaling_documenation_popover = require("./scaling_documenation_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/util/scaling_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ScalingForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      maxResultWindow: _constants.DEFAULT_MAX_RESULT_WINDOW.toLocaleString(),
      modalContent: null,
      showModal: false
    });
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onScalingTypeSelect", optionId => {
      if (this.props.numberOfJoins > 0 && optionId === _constants.SCALING_TYPES.CLUSTERS) {
        this._openModal(optionId, [_i18n.i18n.translate('xpack.maps.source.esSearch.clusterScalingJoinMsg', {
          defaultMessage: `Scaling with clusters does not support joins. Switching to clusters will remove all joins from your layer configuration.`
        })]);
        return;
      }
      if (optionId === _constants.SCALING_TYPES.MVT) {
        const messages = [];
        if (this.props.hasSpatialJoins) {
          messages.push(_i18n.i18n.translate('xpack.maps.source.esSearch.mvtNoSpatialJoinMsg', {
            defaultMessage: `Vector tiles do not support spatial joins. Switching to vector tiles will remove all spatial joins from your layer configuration.`
          }));
        }
        if (this.props.numberOfJoins > 1) {
          messages.push(_i18n.i18n.translate('xpack.maps.source.esSearch.mvtScalingJoinMsg', {
            defaultMessage: `Vector tiles support one term join. Your layer has {numberOfJoins} joins. Switching to vector tiles will keep the first term join and remove all other joins from your layer configuration.`,
            values: {
              numberOfJoins: this.props.numberOfJoins
            }
          }));
        }
        if (messages.length) {
          this._openModal(optionId, messages);
          return;
        }
      }
      this._onScalingTypeChange(optionId);
    });
    (0, _defineProperty2.default)(this, "_onScalingTypeChange", optionId => {
      let layerType;
      if (optionId === _constants.SCALING_TYPES.CLUSTERS) {
        layerType = _constants.LAYER_TYPE.BLENDED_VECTOR;
      } else if (optionId === _constants.SCALING_TYPES.MVT) {
        layerType = _constants.LAYER_TYPE.MVT_VECTOR;
      } else {
        layerType = _constants.LAYER_TYPE.GEOJSON_VECTOR;
      }
      this.props.onChange({
        propName: 'scalingType',
        value: optionId,
        newLayerType: layerType
      });
    });
    (0, _defineProperty2.default)(this, "_onFilterByMapBoundsChange", event => {
      this.props.onChange({
        propName: 'filterByMapBounds',
        value: event.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "_openModal", (optionId, messages) => {
      this.setState({
        modalContent: messages.length ? messages.map((message, index) => {
          return /*#__PURE__*/_react.default.createElement("p", {
            key: index,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 141,
              columnNumber: 20
            }
          }, message);
        }) : null,
        nextScalingType: optionId,
        showModal: true
      });
    });
    (0, _defineProperty2.default)(this, "_closeModal", () => {
      this.setState({
        modalContent: null,
        nextScalingType: undefined,
        showModal: false
      });
    });
    (0, _defineProperty2.default)(this, "_acceptModal", () => {
      if (this.state.nextScalingType) {
        this._onScalingTypeChange(this.state.nextScalingType);
      }
      this._closeModal();
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadIndexSettings();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadIndexSettings() {
    try {
      const dataView = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
      const {
        maxResultWindow
      } = await (0, _load_index_settings.loadIndexSettings)(dataView.getIndexPattern());
      if (this._isMounted) {
        this.setState({
          maxResultWindow: maxResultWindow.toLocaleString()
        });
      }
    } catch (err) {
      return;
    }
  }
  _getLimitOptionLabel() {
    return _i18n.i18n.translate('xpack.maps.source.esSearch.limitScalingLabel', {
      defaultMessage: 'Limit results to {maxResultWindow}',
      values: {
        maxResultWindow: this.state.maxResultWindow
      }
    });
  }
  _getClustersOptionLabel() {
    return _i18n.i18n.translate('xpack.maps.source.esSearch.clusterScalingLabel', {
      defaultMessage: 'Show clusters when results exceed {maxResultWindow}',
      values: {
        maxResultWindow: this.state.maxResultWindow
      }
    });
  }
  _getMvtOptionLabel() {
    return _i18n.i18n.translate('xpack.maps.source.esSearch.useMVTVectorTiles', {
      defaultMessage: 'Use vector tiles'
    });
  }
  _renderModal() {
    if (!this.state.showModal || !this.state.modalContent || this.state.nextScalingType === undefined) {
      return null;
    }
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: _i18n.i18n.translate('xpack.maps.source.esSearch.scalingModal.title', {
        defaultMessage: `Remove unsupported configurations?`
      }),
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: this._closeModal,
      onConfirm: this._acceptModal,
      cancelButtonText: _i18n.i18n.translate('xpack.maps.source.esSearch.scalingModal.cancelBtnLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.maps.source.esSearch.scalingModal.confirmBtnLabel', {
        defaultMessage: 'Accept'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 7
      }
    }, this.state.modalContent);
  }
  _renderClusteringRadio() {
    const clusteringRadio = /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      id: _constants.SCALING_TYPES.CLUSTERS,
      name: "scalingType",
      label: this._getClustersOptionLabel(),
      checked: this.props.scalingType === _constants.SCALING_TYPES.CLUSTERS,
      onChange: () => this._onScalingTypeSelect(_constants.SCALING_TYPES.CLUSTERS),
      disabled: !this.props.supportsClustering,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 7
      }
    });
    return this.props.clusteringDisabledReason ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: this.props.clusteringDisabledReason,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 7
      }
    }, clusteringRadio) : clusteringRadio;
  }
  render() {
    let filterByBoundsSwitch;
    if (this.props.scalingType === _constants.SCALING_TYPES.LIMIT) {
      filterByBoundsSwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: _i18n.i18n.translate('xpack.maps.source.esSearch.extentFilterLabel', {
          defaultMessage: 'Dynamically filter for data in the visible map area'
        }),
        checked: this.props.filterByMapBounds,
        onChange: this._onFilterByMapBoundsChange,
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 7
      }
    }, this._renderModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.scaleTitle",
      defaultMessage: "Scaling",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 13
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_scaling_documenation_popover.ScalingDocumenationPopover, {
      limitOptionLabel: this._getLimitOptionLabel(),
      clustersOptionLabel: this._getClustersOptionLabel(),
      maxResultWindow: this.state.maxResultWindow,
      mvtOptionLabel: this._getMvtOptionLabel(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      id: _constants.SCALING_TYPES.MVT,
      name: "scalingType",
      label: this._getMvtOptionLabel(),
      checked: this.props.scalingType === _constants.SCALING_TYPES.MVT,
      onChange: () => this._onScalingTypeSelect(_constants.SCALING_TYPES.MVT),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 13
      }
    }), this._renderClusteringRadio(), /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      id: _constants.SCALING_TYPES.LIMIT,
      name: "scalingType",
      label: this._getLimitOptionLabel(),
      checked: this.props.scalingType === _constants.SCALING_TYPES.LIMIT,
      onChange: () => this._onScalingTypeSelect(_constants.SCALING_TYPES.LIMIT),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 13
      }
    }))), filterByBoundsSwitch);
  }
}
exports.ScalingForm = ScalingForm;