"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightSourcePanel = RightSourcePanel;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _geo_index_pattern_select = require("../../../../../components/geo_index_pattern_select");
var _geo_field_select = require("../../../../../components/geo_field_select");
var _input_strings = require("../../../../../connected_components/input_strings");
var _relationship_expression = require("./relationship_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/spatial_join_wizard/wizard_form/right_source_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RightSourcePanel(props) {
  const geoFieldSelect = props.dataView ? /*#__PURE__*/_react.default.createElement(_geo_field_select.GeoFieldSelect, {
    value: props.geoField ? props.geoField : '',
    onChange: props.onGeoFieldSelect,
    geoFields: props.geoFields,
    isClearable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.rightSourceTitle', {
    defaultMessage: 'Join source'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _input_strings.inputStrings.relationshipLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_relationship_expression.RelationshipExpression, {
    distance: props.distance,
    onDistanceChange: props.onDistanceChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
    dataView: props.dataView,
    onChange: props.onDataViewSelect,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), geoFieldSelect);
}