"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadAnnotationLibraryFlyout = LoadAnnotationLibraryFlyout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _flyout_container = require("../../shared_components/flyout_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/load_annotation_library_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LoadAnnotationLibraryFlyout({
  eventAnnotationService,
  isLoadLibraryVisible,
  setLoadLibraryFlyoutVisible,
  addLayer,
  isInlineEditing
}) {
  const {
    renderEventAnnotationGroupSavedObjectFinder: EventAnnotationGroupSavedObjectFinder,
    loadAnnotationGroup
  } = eventAnnotationService || {};
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    customFooter: /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      className: "lnsDimensionContainer__footer",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      size: "s",
      iconType: "cross",
      onClick: () => {
        setLoadLibraryFlyoutVisible(false);
      },
      "data-test-subj": "lns-indexPattern-loadLibraryCancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.lens.loadAnnotationsLibrary.cancel', {
      defaultMessage: 'Cancel'
    }))))),
    isOpen: Boolean(isLoadLibraryVisible),
    label: _i18n.i18n.translate('xpack.lens.editorFrame.loadFromLibrary', {
      defaultMessage: 'Select annotations from library'
    }),
    handleClose: () => {
      setLoadLibraryFlyoutVisible(false);
    },
    isInlineEditing: isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          padding: ${euiTheme.size.base}
          height: 100%;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EventAnnotationGroupSavedObjectFinder, {
    onChoose: ({
      id
    }) => {
      loadAnnotationGroup(id).then(loadedGroup => {
        addLayer({
          ...loadedGroup,
          annotationGroupId: id
        });
        setLoadLibraryFlyoutVisible(false);
      });
    },
    onCreateNew: () => {
      addLayer();
      setLoadLibraryFlyoutVisible(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })));
}