"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _clusters_health = require("./clusters_health");
var _clusters_table = require("./clusters_table");
var _find_clusters = require("./find_clusters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/details/clusters_view/clusters_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ClustersView extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onSearchChange", ({
      query,
      error
    }) => {
      if (!error) {
        this.setState({
          clusters: (0, _find_clusters.findClusters)(this.props.request, query)
        });
      }
    });
    const clusters = (0, _find_clusters.findClusters)(this.props.request);
    this.state = {
      clusters,
      showSearchAndStatusBar: Object.keys(clusters).length > 1
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }), this.state.showSearchAndStatusBar ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
      box: {
        placeholder: 'Search by cluster name',
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'status',
        name: _i18n.i18n.translate('inspector.requests.clusters.view.statusFilterLabel', {
          defaultMessage: 'Status'
        }),
        multiSelect: 'or',
        options: [{
          value: 'successful',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "successful",
            textProps: {
              size: 'm',
              color: 'text'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 70,
              columnNumber: 25
            }
          })
        }, {
          value: 'partial',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "partial",
            textProps: {
              size: 'm',
              color: 'text'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 79,
              columnNumber: 25
            }
          })
        }, {
          value: 'skipped',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "skipped",
            textProps: {
              size: 'm',
              color: 'text'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 85,
              columnNumber: 25
            }
          })
        }, {
          value: 'failed',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "failed",
            textProps: {
              size: 'm',
              color: 'text'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 91,
              columnNumber: 25
            }
          })
        }]
      }],
      onChange: this._onSearchChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_clusters_health.ClustersHealth, {
      clusters: this.state.clusters,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_clusters_table.ClustersTable, {
      clusters: this.state.clusters,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }));
  }
}
exports.ClustersView = ClustersView;
(0, _defineProperty2.default)(ClustersView, "shouldShow", request => {
  var _request$response, _request$response$jso, _request$response$jso2, _request$response2, _request$response2$js, _request$response2$js2;
  return Boolean(((_request$response = request.response) === null || _request$response === void 0 ? void 0 : (_request$response$jso = _request$response.json) === null || _request$response$jso === void 0 ? void 0 : (_request$response$jso2 = _request$response$jso.rawResponse) === null || _request$response$jso2 === void 0 ? void 0 : _request$response$jso2._shards) || ((_request$response2 = request.response) === null || _request$response2 === void 0 ? void 0 : (_request$response2$js = _request$response2.json) === null || _request$response2$js === void 0 ? void 0 : (_request$response2$js2 = _request$response2$js.rawResponse) === null || _request$response2$js2 === void 0 ? void 0 : _request$response2$js2._clusters));
});