"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageViewsFlyout = ManageViewsFlyout;
var _react = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/saved_views/manage_views_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const searchConfig = {
  box: {
    incremental: true
  }
};
function ManageViewsFlyout({
  onClose,
  views = [],
  onSwitchView,
  onMakeDefaultView,
  onDeleteView,
  loading,
  triggerRef
}) {
  // Add name as top level property to allow in memory search
  const namedViews = (0, _react.useMemo)(() => views.map(addOwnName), [views]);
  const renderName = (name, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.renderName.button.ariaLabel', {
      defaultMessage: 'Switch to {name}',
      values: {
        name
      }
    }),
    key: item.id,
    "data-test-subj": "infraRenderNameButton",
    onClick: () => {
      onSwitchView(item.id);
      onClose();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, name);
  const renderDeleteAction = item => {
    return /*#__PURE__*/_react.default.createElement(DeleteConfimation, {
      key: item.id,
      isDisabled: item.attributes.isDefault,
      onConfirm: () => {
        onDeleteView(item.id);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    });
  };
  const renderMakeDefaultAction = item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.infra.renderMakeDefaultAction.defaultButton.ariaLabel', {
        defaultMessage: 'Mark as default'
      }),
      key: item.id,
      "data-test-subj": "infraRenderMakeDefaultActionButton",
      iconType: item.attributes.isDefault ? 'starFilled' : 'starEmpty',
      size: "s",
      onClick: () => {
        onMakeDefaultView(item.id);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    });
  };
  const handleCloseFlyout = () => {
    onClose();
    requestAnimationFrame(() => {
      var _triggerRef$current;
      (_triggerRef$current = triggerRef.current) === null || _triggerRef$current === void 0 ? void 0 : _triggerRef$current.focus();
    });
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.infra.openView.columnNames.name', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    render: renderName
  }, {
    name: _i18n.i18n.translate('xpack.infra.openView.columnNames.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: renderMakeDefaultAction
    }, {
      available: item => !item.attributes.isStatic,
      render: renderDeleteAction
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleCloseFlyout,
    "data-test-subj": "loadViewsFlyout",
    "aria-label": _i18n.i18n.translate('xpack.infra.openView.flyout.ariaLabel', {
      defaultMessage: 'Manage saved views dialog'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Manage saved views",
    id: "xpack.infra.openView.flyoutHeader",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: namedViews,
    columns: columns,
    loading: loading,
    search: searchConfig,
    pagination: true,
    sorting: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.manageViewsFlyout.cancelButton.ariaLabel', {
      defaultMessage: 'Cancel'
    }),
    "data-test-subj": "cancelSavedViewModal",
    onClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Cancel",
    id: "xpack.infra.openView.cancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  })))));
}
const DeleteConfimation = ({
  isDisabled,
  onConfirm
}) => {
  const [isConfirmVisible, toggleVisibility] = (0, _useToggle.default)(false);
  return isConfirmVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.deleteConfimation.cancelButton.ariaLabel', {
      defaultMessage: 'Cancel'
    }),
    onClick: toggleVisibility,
    "data-test-subj": "hideConfirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "cancel",
    id: "xpack.infra.waffle.savedViews.cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isDisabled,
    fill: true,
    iconType: "trash",
    color: "danger",
    onClick: onConfirm,
    "data-test-subj": "showConfirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Delete view?",
    id: "xpack.infra.openView.actionNames.deleteConfirmation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.infra.deleteConfimation.deleteButton.ariaLabel', {
      defaultMessage: 'Delete'
    }),
    "data-test-subj": "infraDeleteConfimationButton",
    iconType: "trash",
    color: "danger",
    size: "s",
    onClick: toggleVisibility,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  });
};

/**
 * Helpers
 */
const addOwnName = view => ({
  ...view,
  name: view.attributes.name
});