"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withExecuteToolSpan = withExecuteToolSpan;
var _types = require("util/types");
var _std = require("@kbn/std");
var _types2 = require("./types");
var _with_active_inference_span = require("./with_active_inference_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Wrapper around {@link withActiveInferenceSpan} that sets the right attributes for a execute_tool operation span.
 * @param options
 * @param cb
 */
function withExecuteToolSpan(toolName, options, cb) {
  const {
    description,
    toolCallId,
    input
  } = options.tool;
  return (0, _with_active_inference_span.withActiveInferenceSpan)(`Tool: ${toolName}`, {
    ...options,
    attributes: {
      ...options.attributes,
      [_types2.GenAISemanticConventions.GenAIToolName]: toolName,
      [_types2.GenAISemanticConventions.GenAIOperationName]: 'execute_tool',
      [_types2.GenAISemanticConventions.GenAIToolCallId]: toolCallId,
      [_types2.ElasticGenAIAttributes.InferenceSpanKind]: 'TOOL',
      [_types2.ElasticGenAIAttributes.ToolDescription]: description,
      [_types2.ElasticGenAIAttributes.ToolParameters]: (0, _std.safeJsonStringify)(input)
    }
  }, span => {
    if (!span) {
      return cb();
    }
    const res = cb(span);
    if ((0, _types.isPromise)(res)) {
      return res.then(value => {
        const stringified = (0, _std.safeJsonStringify)(value);
        if (stringified) {
          span.setAttribute('output.value', stringified);
        }
        return value;
      });
    }
    return res;
  });
}