"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAIAdapter = void 0;
var _rxjs = require("rxjs");
var _event_source_stream_into_observable = require("../../../util/event_source_stream_into_observable");
var _simulated_function_calling = require("../../simulated_function_calling");
var _utils = require("../../utils");
var _to_openai = require("./to_openai");
var _process_openai_stream = require("./process_openai_stream");
var _emit_token_count_if_missing = require("./emit_token_count_if_missing");
var _get_temperature = require("../../utils/get_temperature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAIAdapter = exports.openAIAdapter = {
  chatComplete: ({
    executor,
    system,
    messages,
    toolChoice,
    tools,
    temperature = 0,
    functionCalling = 'auto',
    modelName: modelName,
    logger,
    abortSignal,
    metadata
  }) => {
    const connector = executor.getConnector();
    const useSimulatedFunctionCalling = functionCalling === 'auto' ? !(0, _utils.isNativeFunctionCallingSupported)(connector) : functionCalling === 'simulated';
    let request;
    if (useSimulatedFunctionCalling) {
      const wrapped = (0, _simulated_function_calling.wrapWithSimulatedFunctionCalling)({
        system,
        messages,
        toolChoice,
        tools
      });
      request = {
        stream: true,
        ...(0, _get_temperature.getTemperatureIfValid)(temperature, {
          connector,
          modelName
        }),
        model: modelName,
        messages: (0, _to_openai.messagesToOpenAI)({
          system: wrapped.system,
          messages: wrapped.messages
        })
      };
    } else {
      request = {
        stream: true,
        ...(0, _get_temperature.getTemperatureIfValid)(temperature, {
          connector,
          modelName
        }),
        model: modelName,
        messages: (0, _to_openai.messagesToOpenAI)({
          system,
          messages
        }),
        tool_choice: (0, _to_openai.toolChoiceToOpenAI)(toolChoice, {
          connector,
          tools
        }),
        tools: (0, _to_openai.toolsToOpenAI)(tools)
      };
    }
    return (0, _rxjs.defer)(() => {
      return executor.invoke({
        subAction: 'stream',
        subActionParams: {
          body: JSON.stringify(request),
          signal: abortSignal,
          stream: true,
          ...(metadata !== null && metadata !== void 0 && metadata.connectorTelemetry ? {
            telemetryMetadata: metadata.connectorTelemetry
          } : {})
        }
      });
    }).pipe((0, _utils.handleConnectorResponse)({
      processStream: _event_source_stream_into_observable.eventSourceStreamIntoObservable
    }), (0, _process_openai_stream.processOpenAIStream)(), (0, _emit_token_count_if_missing.emitTokenCountEstimateIfMissing)({
      request
    }), useSimulatedFunctionCalling ? (0, _simulated_function_calling.parseInlineFunctionCalls)({
      logger
    }) : _rxjs.identity);
  }
};