"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureMultiTurn = ensureMultiTurn;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Two consecutive messages with USER role or two consecutive messages with ASSISTANT role are not allowed.
 * Consecutive messages with TOOL role are allowed.
 */
function checkMessageRoleSequenceValid(prevMessage, message) {
  if (!prevMessage) {
    return {
      roleSequenceValid: true
    };
  }
  if (prevMessage.role === _inferenceCommon.MessageRole.User && message.role === _inferenceCommon.MessageRole.User) {
    return {
      roleSequenceValid: false,
      intermediaryRole: _inferenceCommon.MessageRole.Assistant
    };
  }
  if (prevMessage.role === _inferenceCommon.MessageRole.Assistant && message.role === _inferenceCommon.MessageRole.Assistant) {
    return {
      roleSequenceValid: false,
      intermediaryRole: _inferenceCommon.MessageRole.User
    };
  }
  if (prevMessage.role === _inferenceCommon.MessageRole.Tool && message.role === _inferenceCommon.MessageRole.Tool) {
    return {
      roleSequenceValid: true
    };
  }
  return {
    roleSequenceValid: true
  };
}
function ensureMultiTurn(messages) {
  const next = [];
  messages.forEach(message => {
    const prevMessage = next[next.length - 1];
    const result = checkMessageRoleSequenceValid(prevMessage, message);
    if (!result.roleSequenceValid) {
      const content = '-';
      next.push(
      // UserMessage is not assignable to AssistantMessage, so we need
      // to help TypeScript a bit
      result.intermediaryRole === _inferenceCommon.MessageRole.User ? {
        content,
        role: result.intermediaryRole
      } : {
        content,
        role: result.intermediaryRole
      });
    }
    next.push(message);
  });
  return next;
}