"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldSelectionFormSchema = exports.FieldSelectionStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _shared_imports = require("../../../../shared_imports");
var _api = require("../../../services/api");
var _create_policy_context = require("../create_policy_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/enrich_policy_create/steps/field_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fieldSelectionFormSchema = exports.fieldSelectionFormSchema = {
  matchField: {
    // Since this ComboBoxField is not a multi-select, we need to serialize/deserialize the value
    // into a string to be able to save it in the policy.
    defaultValue: '',
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    serializer: v => {
      return v.join(', ');
    },
    deserializer: v => {
      return v.length === 0 ? [] : v.split(', ');
    },
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldField', {
      defaultMessage: 'Match field'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldRequired', {
        defaultMessage: 'A match field is required.'
      }))
    }]
  },
  enrichFields: {
    defaultValue: [],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.enrichFieldsField', {
      defaultMessage: 'Enrich fields'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.enrichFieldsRequired', {
        defaultMessage: 'At least one enrich field is required.'
      }))
    }]
  }
};
const buildFieldOption = field => ({
  label: field.name,
  prepend: /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: field.normalizedType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 12
    }
  })
});
const FieldSelectionStep = ({
  onBack,
  onNext
}) => {
  var _draft$sourceIndices$, _draft$sourceIndices;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [fieldOptions, setFieldOptions] = (0, _react.useState)([]);
  const [matchFieldOptions, setMatchFieldOptions] = (0, _react.useState)([]);
  const {
    draft,
    updateDraft,
    updateCompletionState
  } = (0, _create_policy_context.useCreatePolicyContext)();
  (0, _react.useEffect)(() => {
    const fetchFields = async () => {
      var _data$commonFields, _data$indices, _data$indices2;
      setIsLoading(true);
      const {
        data
      } = await (0, _api.getFieldsFromIndices)(draft.sourceIndices);
      setIsLoading(false);
      if (data !== null && data !== void 0 && (_data$commonFields = data.commonFields) !== null && _data$commonFields !== void 0 && _data$commonFields.length) {
        setMatchFieldOptions(data.commonFields.map(buildFieldOption));
        // If there is only one index, we can use the fields of that index as match field options
      } else if ((data === null || data === void 0 ? void 0 : (_data$indices = data.indices) === null || _data$indices === void 0 ? void 0 : _data$indices.length) === 1) {
        setMatchFieldOptions(data.indices[0].fields.map(buildFieldOption));
      }
      if (data !== null && data !== void 0 && (_data$indices2 = data.indices) !== null && _data$indices2 !== void 0 && _data$indices2.length) {
        setFieldOptions(data.indices.map(index => ({
          label: index.index,
          options: index.fields.map(buildFieldOption)
        })));
      }
    };
    fetchFields();
  }, [draft.sourceIndices]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: draft,
    schema: fieldSelectionFormSchema,
    id: 'fieldSelectionForm'
  });
  const onSubmit = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (!isValid) {
      return;
    }

    // Update form completion state
    updateCompletionState(prevCompletionState => ({
      ...prevCompletionState,
      fieldsSelectionStep: true
    }));

    // Update draft state with the data of the form
    updateDraft(prevDraft => ({
      ...prevDraft,
      ...data
    }));

    // And then navigate to the next step
    onNext();
  };
  const hasSelectedMultipleIndices = ((_draft$sourceIndices$ = (_draft$sourceIndices = draft.sourceIndices) === null || _draft$sourceIndices === void 0 ? void 0 : _draft$sourceIndices.length) !== null && _draft$sourceIndices$ !== void 0 ? _draft$sourceIndices$ : 0) > 1;
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "fieldSelectionForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, !isLoading && hasSelectedMultipleIndices && matchFieldOptions.length === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.noCommonFieldsFoundError', {
      defaultMessage: 'No common fields'
    }),
    color: "danger",
    iconType: "error",
    "data-test-subj": "noCommonFieldsError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldError",
    defaultMessage: "The selected indices don't have any fields in common.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "matchField",
    component: _shared_imports.ComboBoxField,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "data-test-subj": "matchFieldPopover",
      content: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldPopover', {
        defaultMessage: 'The field in your source indices to match with the incoming documents.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }),
    componentProps: {
      fullWidth: false,
      helpText: hasSelectedMultipleIndices ? _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldHelpText', {
        defaultMessage: 'The match field must be the same across all selected source indices.'
      }) : undefined,
      euiFieldProps: {
        'data-test-subj': 'matchField',
        placeholder: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.matchFieldPlaceholder', {
          defaultMessage: 'Select a field'
        }),
        noSuggestions: false,
        singleSelection: {
          asPlainText: true
        },
        options: matchFieldOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "enrichFields",
    component: _shared_imports.ComboBoxField,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "data-test-subj": "enrichFieldsPopover",
      content: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.EnrichFieldsFieldPopover', {
        defaultMessage: 'The fields to add to your incoming documents.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }),
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': 'enrichFields',
        placeholder: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.enrichFieldsPlaceholder', {
          defaultMessage: 'Select fields to enrich'
        }),
        noSuggestions: false,
        options: fieldOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "fieldSelectionStep",
    justifyContent: "spaceBetween",
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconSide: "left",
    iconType: "arrowLeft",
    "data-test-subj": "backButton",
    onClick: onBack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.backButtonLabel",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    iconSide: "right",
    iconType: "arrowRight",
    disabled: form.isValid === false,
    "data-test-subj": "nextButton",
    onClick: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStep.nextButtonLabel",
    defaultMessage: "Next",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  })))));
};
exports.FieldSelectionStep = FieldSelectionStep;