"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _documentation = require("../../../../../../services/documentation");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../../constants");
var _code_block = require("../../../code_block");
var _field_types = require("../field_types");
var _edit_field_header_form = require("./edit_field_header_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/edit_field/edit_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const limitStringLength = (text, limit = 18) => {
  if (text.length <= limit) {
    return text;
  }
  return `...${text.substr(limit * -1)}`;
};
// The default FormWrapper is the <EuiForm />, which wraps the form with
// a <div>. We can't have a div as first child of the Flyout as it breaks
// the height calculation and does not render the footer position correctly.
const FormWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const EditField = exports.EditField = /*#__PURE__*/_react.default.memo(({
  form,
  field,
  allFields,
  exitEdit,
  updateField,
  kibanaVersion
}) => {
  const submitForm = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid) {
      updateField({
        ...field,
        source: data
      });
    }
  };
  const {
    isMultiField
  } = field;
  const isFormModified = (0, _hook_form_lib.useFormIsModified)({
    form
  });
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    FormWrapper: FormWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editMultiFieldTitle', {
    defaultMessage: "Edit multi-field ''{fieldName}''",
    values: {
      fieldName: limitStringLength(field.source.name)
    }
  }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldTitle', {
    defaultMessage: "Edit field ''{fieldName}''",
    values: {
      fieldName: limitStringLength(field.source.name)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, ({
    type,
    subType
  }) => {
    var _subType$, _type$, _type$2, _subType$2;
    const linkDocumentation = _documentation.documentationService.getTypeDocLink(subType === null || subType === void 0 ? void 0 : (_subType$ = subType[0]) === null || _subType$ === void 0 ? void 0 : _subType$.value) || _documentation.documentationService.getTypeDocLink(type === null || type === void 0 ? void 0 : (_type$ = type[0]) === null || _type$ === void 0 ? void 0 : _type$.value);
    if (!linkDocumentation) {
      return null;
    }
    const typeDefinition = _constants.TYPE_DEFINITION[type === null || type === void 0 ? void 0 : (_type$2 = type[0]) === null || _type$2 === void 0 ? void 0 : _type$2.value];
    const subTypeDefinition = _constants.TYPE_DEFINITION[subType === null || subType === void 0 ? void 0 : (_subType$2 = subType[0]) === null || _subType$2 === void 0 ? void 0 : _subType$2.value];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: linkDocumentation,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editField.typeDocumentation', {
      defaultMessage: '{type} documentation',
      values: {
        type: subTypeDefinition ? subTypeDefinition.label : typeDefinition.label
      }
    })));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldPath",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    padding: "small",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, field.path.join(' > '))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_field_header_form.EditFieldHeaderForm, {
    defaultValue: field.source,
    isRootLevelField: field.parentId === undefined,
    isMultiField: isMultiField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, ({
    type,
    subType
  }) => {
    var _type$3, _subType$3;
    const ParametersForm = (0, _field_types.getParametersFormForType)(type === null || type === void 0 ? void 0 : (_type$3 = type[0]) === null || _type$3 === void 0 ? void 0 : _type$3.value, subType === null || subType === void 0 ? void 0 : (_subType$3 = subType[0]) === null || _subType$3 === void 0 ? void 0 : _subType$3.value);
    if (!ParametersForm) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(ParametersForm
    // As the component "ParametersForm" does not change when switching type, and all the props
    // also remain the same (===), adding a key give us *a new instance* each time we change the type or subType.
    // This will trigger an unmount of all the previous form fields and then mount the new ones.
    , {
      key: subType !== null && subType !== void 0 ? subType : type,
      field: field,
      allFields: allFields,
      isMultiField: isMultiField,
      kibanaVersion: kibanaVersion,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    });
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, form.isSubmitted && !form.isValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldFlyout.validationErrorTitle', {
      defaultMessage: 'Fix errors in form before continuing.'
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "formError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, isFormModified && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldFlyout.formCompletionTooltip', {
      defaultMessage: "Default settings are applied to the settings that you haven't changed."
    }),
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 27
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldFlyout.formCompletionGuide', {
    defaultMessage: 'Review all settings before updating '
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 27
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: exitEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldCancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: submitForm,
    type: "submit",
    disabled: form.isSubmitted && !form.isValid || !isFormModified,
    "data-test-subj": "editFieldUpdateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldUpdateButtonLabel', {
    defaultMessage: 'Update'
  }))))));
});