"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_details/manage_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManageButton = ({
  actions,
  componentTemplateDetails
}) => {
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const items = actions.map(({
    name,
    icon,
    getIsDisabled,
    closePopoverOnClick,
    handleActionClick
  }) => {
    const isDisabled = getIsDisabled ? getIsDisabled(componentTemplateDetails) : false;
    return {
      name,
      icon,
      disabled: isDisabled,
      toolTipContent: isDisabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.manageButtonDisabledTooltipLabel",
        defaultMessage: "Template is in use and cannot be deleted",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }) : null,
      onClick: () => {
        handleActionClick();
        if (closePopoverOnClick) {
          setIsPopOverOpen(false);
        }
      },
      'data-test-subj': 'action'
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "manageComponentTemplatePanel",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "manageComponentTemplateButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsPopOverOpen(prevBoolean => !prevBoolean),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateDetails.manageButtonLabel",
      defaultMessage: "Manage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "rightUp",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "manageComponentTemplateContextMenu",
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.manageContextMenuPanelTitle', {
        defaultMessage: 'Options'
      }),
      items
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
};
exports.ManageButton = ManageButton;