"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchCursor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SearchCursor {
  constructor(indexPatternTitle, settings, clients, abortController, logger) {
    (0, _defineProperty2.default)(this, "cursorId", void 0);
    this.indexPatternTitle = indexPatternTitle;
    this.settings = settings;
    this.clients = clients;
    this.abortController = abortController;
    this.logger = logger;
  }
  /**
   * Safely logs debugging meta info from search results
   * @param clientDetails: Details from the data.search client
   * @param results:       Raw data from ES
   */
  logSearchResults(clientDetails, results) {
    var _trackedTotal$value, _trackedTotal$relatio;
    const {
      hits: resultsHits,
      ...headerWithCursor
    } = results;
    const {
      hits,
      ...hitsMeta
    } = resultsHits;
    const trackedTotal = resultsHits.total;
    const currentTotal = (_trackedTotal$value = trackedTotal === null || trackedTotal === void 0 ? void 0 : trackedTotal.value) !== null && _trackedTotal$value !== void 0 ? _trackedTotal$value : resultsHits.total;
    const totalAccuracy = (_trackedTotal$relatio = trackedTotal === null || trackedTotal === void 0 ? void 0 : trackedTotal.relation) !== null && _trackedTotal$relatio !== void 0 ? _trackedTotal$relatio : 'unknown';
    this.logger.debug(`Received total hits: ${currentTotal}. Accuracy: ${totalAccuracy}.`);

    // reconstruct the data.search response (w/out the data) for logging
    const {
      pit_id: newPitId,
      _scroll_id: newScrollId,
      ...header
    } = headerWithCursor;
    const logInfo = {
      ...clientDetails,
      rawResponse: {
        ...header,
        hits: hitsMeta,
        pit_id: newPitId ? `${this.formatCursorId(newPitId)}` : undefined,
        _scroll_id: newScrollId ? `${this.formatCursorId(newScrollId)}` : undefined
      }
    };
    this.logger.debug(`Result details: ${JSON.stringify(logInfo)}`);
  }

  /**
   * Method to avoid logging the entire PIT: it could be megabytes long
   */
  formatCursorId(cursorId) {
    const byteSize = cursorId ? Buffer.byteLength(cursorId, 'utf-8') : 0;
    return (cursorId === null || cursorId === void 0 ? void 0 : cursorId.substring(0, 12)) + `[${byteSize} bytes]`;
  }
}
exports.SearchCursor = SearchCursor;