"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationSyncStatus = void 0;
exports.getIntegrationStatus = getIntegrationStatus;
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../../../common/types");
var _hooks = require("../../../../hooks");
var _integration_sync_flyout = require("./integration_sync_flyout");
var _integration_status_badge = require("./integration_status_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/outputs_table/integration_sync_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getIntegrationStatus(statuses) {
  return statuses.some(current => current === _types.SyncStatus.FAILED) ? _types.SyncStatus.FAILED : statuses.some(current => current === _types.SyncStatus.WARNING) ? _types.SyncStatus.WARNING : statuses.some(current => current === _types.SyncStatus.SYNCHRONIZING) ? _types.SyncStatus.SYNCHRONIZING : _types.SyncStatus.COMPLETED;
}
const IntegrationSyncStatus = exports.IntegrationSyncStatus = /*#__PURE__*/(0, _react.memo)(({
  output
}) => {
  const {
    data: syncedIntegrationsStatus,
    error
  } = (0, _hooks.useGetRemoteSyncedIntegrationsStatusQuery)(output.id, {
    enabled: output.type === 'remote_elasticsearch' && output.sync_integrations
  });
  const [showStatusFlyout, setShowStatusFlyout] = (0, _react.useState)(false);
  const status = (0, _react.useMemo)(() => {
    var _syncedIntegrationsSt, _syncedIntegrationsSt2;
    if (output.type !== 'remote_elasticsearch') {
      return 'NA';
    }
    if (!output.sync_integrations) {
      return 'DISABLED';
    }
    if (!error && !syncedIntegrationsStatus) {
      return 'SYNCHRONIZING';
    }
    const installedSyncedIntegrations = ((_syncedIntegrationsSt = syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.integrations) !== null && _syncedIntegrationsSt !== void 0 ? _syncedIntegrationsSt : []).filter(integration => {
      var _integration$install_, _integration$install_2;
      return !(((_integration$install_ = integration.install_status) === null || _integration$install_ === void 0 ? void 0 : _integration$install_.main) === 'not_installed' && ((_integration$install_2 = integration.install_status) === null || _integration$install_2 === void 0 ? void 0 : _integration$install_2.remote) === 'not_installed');
    });
    const statuses = [...(installedSyncedIntegrations.map(integration => integration.sync_status) || []), ...Object.values((_syncedIntegrationsSt2 = syncedIntegrationsStatus === null || syncedIntegrationsStatus === void 0 ? void 0 : syncedIntegrationsStatus.custom_assets) !== null && _syncedIntegrationsSt2 !== void 0 ? _syncedIntegrationsSt2 : {}).map(asset => asset.sync_status)];
    const integrationStatus = getIntegrationStatus(statuses).toUpperCase();
    const newStatus = error !== null && error !== void 0 && error.message || syncedIntegrationsStatus !== null && syncedIntegrationsStatus !== void 0 && syncedIntegrationsStatus.error ? 'FAILED' : integrationStatus;
    return newStatus;
  }, [output, syncedIntegrationsStatus, error]);
  const onClick = () => {
    setShowStatusFlyout(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_integration_status_badge.IntegrationStatusBadge, {
    status: status,
    onClick: onClick,
    onClickAriaLabel: 'Show details',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), showStatusFlyout && /*#__PURE__*/_react.default.createElement(_integration_sync_flyout.IntegrationSyncFlyout, {
    onClose: () => setShowStatusFlyout(false),
    syncedIntegrationsStatus: error ? {
      integrations: [],
      error: error.message
    } : syncedIntegrationsStatus,
    outputName: output.name,
    syncUninstalledIntegrations: output.type === 'remote_elasticsearch' && (output === null || output === void 0 ? void 0 : output.sync_uninstalled_integrations),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }));
});