"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationPageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsYaml = require("js-yaml");
var _common = require("@kbn/spaces-plugin/common");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../integrations/hooks");
var _services = require("../../../../../../../../services");
var _hooks2 = require("../../../../../../hooks");
var _components = require("../../../../../../components");
var _hooks3 = require("../../hooks");
var _ = require("..");
var _services2 = require("../../../services");
var _components2 = require("../../../components");
var _prepare_input_pkg_policy_dataset = require("../../../services/prepare_input_pkg_policy_dataset");
var _ensure_kibana_assets_installed = require("../../../../../../services/ensure_kibana_assets_installed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/components/page_steps/add_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandableAdvancedSettings = ({
  children
}) => {
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: isShowingAdvanced ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",
    defaultMessage: "Advanced options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 17
    }
  }))))), isShowingAdvanced && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 31
    }
  }, children)));
};
const AddIntegrationError = ({
  error,
  title
}) => /*#__PURE__*/_react.default.createElement(_components.Error, {
  title: title ? title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegration.errorTitle",
    defaultMessage: "Error adding integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }),
  error: error,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 3
  }
});
const AddIntegrationPageStep = props => {
  var _packageInfo$name;
  const {
    onNext,
    onBack,
    isManaged,
    setIsManaged,
    packageInfo,
    integrationInfo,
    agentPolicy
  } = props;
  const {
    spaceId
  } = (0, _hooks2.useFleetStatus)();
  const [basePolicyError, setBasePolicyError] = (0, _react.useState)();
  const {
    notifications
  } = (0, _hooks2.useStartServices)();
  const [formState, setFormState] = (0, _react.useState)('VALID');
  const [validationResults, setValidationResults] = (0, _react.useState)();
  const confirmForceInstall = (0, _hooks.useConfirmForceInstall)();
  const [packagePolicy, setPackagePolicy] = (0, _react.useState)({
    name: '',
    description: '',
    namespace: '',
    policy_id: '',
    policy_ids: [''],
    enabled: true,
    inputs: []
  });

  // Update package policy validation
  const updatePackagePolicyValidation = (0, _react.useCallback)(newPackagePolicy => {
    const newValidationResult = (0, _services2.validatePackagePolicy)({
      ...packagePolicy,
      ...newPackagePolicy
    }, packageInfo, _jsYaml.load);
    setValidationResults(newValidationResult);
    // eslint-disable-next-line no-console
    console.debug('Package policy validation results', newValidationResult);
    return newValidationResult;
  }, [packageInfo, packagePolicy]);
  // Update package policy method
  const updatePackagePolicy = (0, _react.useCallback)(updatedFields => {
    const newPackagePolicy = {
      ...packagePolicy,
      ...updatedFields
    };
    setPackagePolicy(newPackagePolicy);

    // eslint-disable-next-line no-console
    console.debug('Package policy updated', newPackagePolicy);
    const newValidationResults = updatePackagePolicyValidation(newPackagePolicy);
    const hasPackage = newPackagePolicy.package;
    const hasValidationErrors = newValidationResults ? (0, _services2.validationHasErrors)(newValidationResults) : false;
    if (hasPackage && !hasValidationErrors) {
      setFormState('VALID');
    } else {
      setFormState('INVALID');
    }
  }, [packagePolicy, updatePackagePolicyValidation]);

  // Save package policy
  const savePackagePolicy = (0, _react.useCallback)(async ({
    newPackagePolicy,
    force
  }) => {
    var _result$data;
    setFormState('LOADING');
    const {
      policy,
      forceCreateNeeded
    } = await (0, _prepare_input_pkg_policy_dataset.prepareInputPackagePolicyDataset)(newPackagePolicy);
    const result = await (0, _hooks2.sendCreatePackagePolicy)({
      ...policy,
      force: forceCreateNeeded || force
    });
    setFormState('SUBMITTED');
    if (!result.error && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.item.package) await (0, _ensure_kibana_assets_installed.ensurePackageKibanaAssetsInstalled)({
      currentSpaceId: spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID,
      pkgName: result.data.item.package.name,
      pkgVersion: result.data.item.package.version,
      toasts: notifications.toasts
    });
    return result;
  }, [notifications.toasts, spaceId]);
  const onSubmit = (0, _react.useCallback)(async ({
    force = false
  } = {}) => {
    const hasErrors = validationResults ? (0, _services2.validationHasErrors)(validationResults) : false;
    if (formState === 'VALID' && hasErrors) {
      setFormState('INVALID');
      return;
    }
    setFormState('LOADING');
    const {
      error
    } = await savePackagePolicy({
      newPackagePolicy: packagePolicy,
      force
    });
    if (error) {
      if ((0, _services.isVerificationError)(error)) {
        const forceInstall = await confirmForceInstall(packageInfo);
        if (forceInstall) {
          onSubmit({
            force: true
          });
        } else {
          setFormState('VALID');
        }
        return;
      }
      notifications.toasts.addError(error, {
        title: 'Error'
      });
      setFormState('VALID');
    } else {
      onNext();
    }
  }, [validationResults, savePackagePolicy, formState, packagePolicy, notifications.toasts, confirmForceInstall, packageInfo, onNext]);
  (0, _react.useEffect)(() => {
    const getBasePolicy = async () => {
      if (!agentPolicy) {
        return;
      }
      const {
        packagePolicy: basePackagePolicy,
        error
      } = await (0, _hooks3.sendGeneratePackagePolicy)(agentPolicy.id, packageInfo, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name);
      if (error) {
        setBasePolicyError(error);
      }
      updatePackagePolicy(basePackagePolicy);
    };
    getBasePolicy();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  const extensionView = (0, _hooks2.useUIExtension)((_packageInfo$name = packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '', 'package-policy-create-multi-step');
  const addIntegrationExtensionView = (0, _react.useMemo)(() => {
    return extensionView && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(extensionView.Component, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    }));
  }, [extensionView]);
  const content = (0, _react.useMemo)(() => {
    if (packageInfo.name !== 'endpoint') {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'l',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_components2.StepConfigurePackagePolicy, {
        packageInfo: packageInfo,
        showOnlyIntegration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
        packagePolicy: packagePolicy,
        updatePackagePolicy: updatePackagePolicy,
        validationResults: validationResults,
        submitAttempted: formState === 'INVALID',
        noTopRule: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 11
        }
      }), validationResults && /*#__PURE__*/_react.default.createElement(ExpandableAdvancedSettings, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_components2.StepDefinePackagePolicy, {
        packageInfo: packageInfo,
        packagePolicy: packagePolicy,
        updatePackagePolicy: updatePackagePolicy,
        validationResults: validationResults,
        submitAttempted: formState === 'INVALID',
        noAdvancedToggle: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 268,
          columnNumber: 15
        }
      })));
    }
  }, [formState, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name, packageInfo, packagePolicy, updatePackagePolicy, validationResults]);
  if (!agentPolicy) {
    return /*#__PURE__*/_react.default.createElement(AddIntegrationError, {
      error: _i18n.i18n.translate('xpack.fleet.addIntegration.noAgentPolicy', {
        defaultMessage: 'Error creating agent policy.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 7
      }
    });
  }
  if (basePolicyError) {
    return /*#__PURE__*/_react.default.createElement(AddIntegrationError, {
      error: basePolicyError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isManaged ? null : /*#__PURE__*/_react.default.createElement(_.StandaloneModeWarningCallout, {
    setIsManaged: setIsManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 27
    }
  }), content, addIntegrationExtensionView, /*#__PURE__*/_react.default.createElement(_.NotObscuredByBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_.CreatePackagePolicyBottomBar, {
    cancelClickHandler: isManaged ? onBack : () => setIsManaged(true),
    onNext: onSubmit,
    isLoading: formState === 'LOADING',
    isDisabled: formState === 'INVALID',
    loadingMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createFirstPackagePolicy.savingPackagePolicy",
      defaultMessage: "Saving policy...",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 11
      }
    }),
    actionMessage: isManaged ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createFirstPackagePolicy.confirmIncomingDataButton",
      defaultMessage: "Confirm incoming data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createFirstPackagePolicy.installAgentButton",
      defaultMessage: "Save and continue",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }));
};
exports.AddIntegrationPageStep = AddIntegrationPageStep;