"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiTextInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/multi_text_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Row = ({
  index,
  value,
  fieldLabel,
  onChange,
  onDelete,
  onBlur,
  autoFocus,
  isDisabled,
  isMultiRow
}) => {
  const onDeleteHandler = (0, _react.useCallback)(() => {
    onDelete(index);
  }, [onDelete, index]);
  const onChangeHandler = (0, _react.useCallback)(e => {
    onChange(index, e.target.value);
  }, [onChange, index]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: value,
    onChange: onChangeHandler,
    autoFocus: autoFocus,
    disabled: isDisabled,
    onBlur: onBlur,
    "aria-label": isMultiRow ? _i18n.i18n.translate('xpack.fleet.multiTextInput.ariaLabel', {
      defaultMessage: '"{fieldLabel}" input {index}',
      values: {
        fieldLabel,
        index: index + 1
      }
    }) : fieldLabel,
    "data-test-subj": `multiTextInputRow-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })), isMultiRow && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onDeleteHandler,
    iconType: "cross",
    disabled: isDisabled,
    "aria-label": _i18n.i18n.translate('xpack.fleet.multiTextInput.deleteRowButton', {
      defaultMessage: 'Delete "{fieldLabel}" input {index}',
      values: {
        fieldLabel,
        index: index + 1
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  })));
};
function defaultValue(value) {
  return value.length > 0 ? value : [''];
}
const MultiTextInput = ({
  fieldLabel,
  value,
  onChange,
  onBlur,
  isInvalid,
  isDisabled,
  errors,
  'data-test-subj': dataTestSubj
}) => {
  const [autoFocus, setAutoFocus] = (0, _react.useState)(false);
  const [rows, setRows] = (0, _react.useState)(() => defaultValue(value));
  const [previousRows, setPreviousRows] = (0, _react.useState)(rows);
  (0, _react.useEffect)(() => {
    if (previousRows === rows) {
      return;
    }
    setPreviousRows(rows);
    if (rows[rows.length - 1] === '') {
      onChange(rows.slice(0, rows.length - 1));
    } else {
      onChange(rows);
    }
  }, [onChange, previousRows, rows]);
  const onDeleteHandler = (0, _react.useCallback)(idx => {
    setRows([...rows.slice(0, idx), ...rows.slice(idx + 1)]);
  }, [rows]);
  const onChangeHandler = (0, _react.useCallback)((idx, newValue) => {
    const newRows = [...rows];
    newRows[idx] = newValue;
    setRows(newRows);
  }, [rows]);
  const addRowHandler = (0, _react.useCallback)(() => {
    setAutoFocus(true);
    setRows([...rows, '']);
  }, [rows]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, rows.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Row, {
    index: idx,
    fieldLabel: fieldLabel,
    onChange: onChangeHandler,
    onDelete: onDeleteHandler,
    onBlur: onBlur,
    value: row,
    autoFocus: autoFocus,
    isDisabled: isDisabled,
    isMultiRow: rows.length > 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: isDisabled,
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    onClick: addRowHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.multiTextInput.addRow",
    defaultMessage: "Add row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  })));
};
exports.MultiTextInput = MultiTextInput;