"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../../constants");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_delete_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyDeleteProvider = ({
  children,
  hasFleetServer,
  packagePolicies,
  agentPolicy
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const [agentPolicyId, setAgentPolicyId] = (0, _react.useState)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isLoadingAgentsCount, setIsLoadingAgentsCount] = (0, _react.useState)(false);
  const [agentsCount, setAgentsCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const deleteAgentPolicyMutation = (0, _hooks.useDeleteAgentPolicyMutation)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const deleteAgentPolicyPrompt = (agentPolicyIdToDelete, onSuccess = () => undefined) => {
    if (!agentPolicyIdToDelete) {
      throw new Error('No agent policy specified for deletion');
    }
    setIsModalOpen(true);
    setAgentPolicyId(agentPolicyIdToDelete);
    fetchAgentsCount(agentPolicyIdToDelete);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setAgentPolicyId(undefined);
    setIsLoading(false);
    setIsLoadingAgentsCount(false);
    setIsModalOpen(false);
  };
  const deleteAgentPolicy = async () => {
    setIsLoading(true);
    try {
      const {
        data
      } = await deleteAgentPolicyMutation.mutateAsync({
        agentPolicyId: agentPolicyId
      });
      if (data) {
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.successSingleNotificationTitle', {
          defaultMessage: "Deleted agent policy ''{id}''",
          values: {
            id: data.name || data.id
          }
        }));
        if (onSuccessCallback.current) {
          onSuccessCallback.current(agentPolicyId);
        }
      } else {
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.failureSingleNotificationTitle', {
          defaultMessage: "Error deleting agent policy ''{id}''",
          values: {
            id: agentPolicyId
          }
        }));
      }
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.fatalErrorNotificationTitle', {
        defaultMessage: 'Error deleting agent policy'
      }));
    }
    closeModal();
    history.push(getPath('policies_list'));
  };
  const fetchAgentsCount = (0, _react.useCallback)(async agentPolicyToCheck => {
    var _agents$data$total, _agents$data;
    if (!isFleetEnabled || isLoadingAgentsCount) {
      return;
    }
    setIsLoadingAgentsCount(true);
    // filtering out the unenrolled agents assigned to this policy
    const agents = await (0, _hooks.sendGetAgents)({
      showInactive: true,
      kuery: `policy_id:"${agentPolicyToCheck}" and not status: unenrolled`,
      perPage: _constants.SO_SEARCH_LIMIT
    });
    setAgentsCount((_agents$data$total = (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.total) !== null && _agents$data$total !== void 0 ? _agents$data$total : 0);
    setIsLoadingAgentsCount(false);
  }, [isFleetEnabled, isLoadingAgentsCount]);
  const packagePoliciesWithMultiplePolicies = (0, _react.useMemo)(() => {
    // Find if there are package policies that have multiple agent policies
    if (packagePolicies && canUseMultipleAgentPolicies) {
      return packagePolicies.some(policy => (policy === null || policy === void 0 ? void 0 : policy.policy_ids.length) > 1);
    }
    return false;
  }, [canUseMultipleAgentPolicies, packagePolicies]);
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.deletePolicyTitle",
        defaultMessage: "Delete this agent policy?",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 11
        }
      }),
      onCancel: closeModal,
      onConfirm: deleteAgentPolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 11
        }
      }),
      confirmButtonText: isLoading || isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.loadingButtonLabel",
        defaultMessage: "Loading\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 13
        }
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isLoading || isLoadingAgentsCount || !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) && !!agentsCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, packagePoliciesWithMultiplePolicies && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "primary",
      iconType: "info",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.warningSharedIntegrationPolicies",
        defaultMessage: "Fleet has detected that this policy contains integration policies shared by multiple agent policies. These integration policies won't be deleted.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    })), isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.loadingAgentsCountMessage",
      defaultMessage: "Checking amount of affected agents\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 11
      }
    }) : agentsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      title: _i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsTitle', {
        defaultMessage: 'Policy in use'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 11
      }
    }, agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentlessMessage",
      defaultMessage: "Deleting this agent policy will automatically delete integrations assign to {name} and unenroll elastic agent.",
      values: {
        name: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 25
          }
        }, agentPolicy.name)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsMessage",
      defaultMessage: "{agentsCount, plural, one {# agent is} other {# agents are}} assigned to this agent policy. Unassign these agents before deleting this policy. This might include inactive agents.",
      values: {
        agentsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 15
      }
    })) : hasFleetServer ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.fleetServerMessage",
      defaultMessage: "NOTE: This policy has Fleet Server integration, it is required for using Fleet.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.irreversibleMessage",
      defaultMessage: "This action cannot be undone.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 5
    }
  }, children(deleteAgentPolicyPrompt), renderModal());
};
exports.AgentPolicyDeleteProvider = AgentPolicyDeleteProvider;