"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSelectorComponent = exports.SpaceSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/space_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useSpacesContextWrapper = () => {
  const {
    spaces
  } = (0, _hooks.useStartServices)();
  return (0, _react.useMemo)(() => spaces ? spaces.ui.components.getSpacesContextProvider : ({
    children
  }) => children, [spaces]);
};
function useAllSpaces() {
  var _start$spaces, _useSpace;
  const start = (0, _hooks.useStartServices)();
  const useSpace = (_start$spaces = start.spaces) === null || _start$spaces === void 0 ? void 0 : _start$spaces.ui.useSpaces;
  const spacesManager = useSpace === null || useSpace === void 0 ? void 0 : (_useSpace = useSpace()) === null || _useSpace === void 0 ? void 0 : _useSpace.spacesManager;
  const {
    data
  } = (0, _reactQuery.useQuery)(['get-all-spaces'], () => {
    var _spacesManager$getSpa;
    return (_spacesManager$getSpa = spacesManager === null || spacesManager === void 0 ? void 0 : spacesManager.getSpaces({
      purpose: 'any'
    })) !== null && _spacesManager$getSpa !== void 0 ? _spacesManager$getSpa : [];
  });
  const allSpaces = (0, _react.useMemo)(() => data !== null && data !== void 0 ? data : [], [data]);
  return {
    allSpaces
  };
}
const SpaceSelector = props => {
  const Wrapper = useSpacesContextWrapper();
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SpaceSelectorComponent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  })));
};
exports.SpaceSelector = SpaceSelector;
const SpaceSelectorComponent = ({
  setInvalidSpaceError,
  value,
  onChange,
  isDisabled
}) => {
  const res = (0, _hooks.useAgentPoliciesSpaces)();
  const {
    allSpaces
  } = useAllSpaces();
  const [error, setError] = _react.default.useState();
  const renderOption = _react.default.useCallback((option, searchValue, contentClassName) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: option.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, option.label));
  }, []);
  const options = (0, _react.useMemo)(() => {
    var _res$data$items$map, _res$data;
    return (_res$data$items$map = (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.items.map(item => ({
      label: item.name,
      key: item.id,
      color: item.color
    }))) !== null && _res$data$items$map !== void 0 ? _res$data$items$map : [];
  }, [res.data]);
  const selectedOptions = (0, _react.useMemo)(() => {
    if (res.isInitialLoading) {
      return [];
    }
    return value.map(v => {
      var _existingSpace$name;
      const existingOption = options.find(opt => opt.key === v);
      if (existingOption) {
        return existingOption;
      }
      const existingSpace = allSpaces.find(space => space.id === v);
      const color = existingSpace === null || existingSpace === void 0 ? void 0 : existingSpace.color;
      const label = (_existingSpace$name = existingSpace === null || existingSpace === void 0 ? void 0 : existingSpace.name) !== null && _existingSpace$name !== void 0 ? _existingSpace$name : v;
      return existingOption ? existingOption : {
        label,
        key: v,
        color
      };
    });
  }, [options, value, res.isInitialLoading, allSpaces]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "space",
    error: error,
    isDisabled: isDisabled,
    isInvalid: Boolean(error),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: Boolean(error),
    "data-test-subj": 'spaceSelectorComboBox',
    "aria-label": _i18n.i18n.translate('xpack.fleet.agentPolicies.spaceSelectorLabel', {
      defaultMessage: 'Spaces'
    }),
    fullWidth: true,
    options: options,
    renderOption: renderOption,
    selectedOptions: selectedOptions,
    isDisabled: res.isInitialLoading || isDisabled,
    isClearable: false,
    onSearchChange: (searchValue, hasMatchingOptions) => {
      const newError = searchValue.length === 0 || hasMatchingOptions ? undefined : _i18n.i18n.translate('xpack.fleet.agentPolicies.spaceSelectorInvalid', {
        defaultMessage: '{space} is not a valid space.',
        values: {
          space: searchValue
        }
      });
      setError(newError);
      if (setInvalidSpaceError) {
        setInvalidSpaceError(!!newError);
      }
    },
    onChange: newOptions => {
      onChange(newOptions.map(({
        key
      }) => key));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
};
exports.SpaceSelectorComponent = SpaceSelectorComponent;