"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVisValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_legacy_metric/public/components/metric_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricVisValue = props => {
  const {
    style,
    metric,
    onFilter,
    labelConfig,
    colorFullBackground,
    autoScale
  } = props;
  const containerClassName = (0, _classnames.default)('legacyMtrVis__container', {
    'legacyMtrVis__container--light': metric.lightText,
    'legacyMtrVis__container-isfilterable': onFilter,
    'legacyMtrVis__container-isfull': !autoScale && colorFullBackground
  });
  (0, _react.useLayoutEffect)(() => {
    var _props$renderComplete;
    (_props$renderComplete = props.renderComplete) === null || _props$renderComplete === void 0 ? void 0 : _props$renderComplete.call(props);
  }, [props]);

  // for autoScale true we should add background to upper level so that correct colorize full container
  const metricComponent = /*#__PURE__*/_react.default.createElement("div", {
    className: containerClassName,
    css: styles.legacyMtrVisContainer,
    style: autoScale && colorFullBackground ? {} : {
      backgroundColor: metric.bgColor
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "metric_value",
    className: "legacyMtrVis__value",
    css: styles.legacyMtrVisValue,
    style: {
      ...style.spec,
      ...(metric.color ? {
        color: metric.color
      } : {})
    }
    /*
     * Justification for dangerouslySetInnerHTML:
     * This is one of the visualizations which makes use of the HTML field formatters.
     * Since these formatters produce raw HTML, this visualization needs to be able to render them as-is, relying
     * on the field formatter to only produce safe HTML.
     * `metric.value` is set by the MetricVisComponent, so this component must make sure this value never contains
     * any unsafe HTML (e.g. by bypassing the field formatter).
     */,
    dangerouslySetInnerHTML: {
      __html: metric.value
    } // eslint-disable-line react/no-danger
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), labelConfig.show && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "metric_label",
    style: {
      ...labelConfig.style.spec,
      order: labelConfig.position === 'top' ? -1 : 2
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, metric.label));
  if (onFilter) {
    return /*#__PURE__*/_react.default.createElement("button", {
      "data-test-subj": "metric_value_button",
      css: {
        display: 'block'
      },
      onClick: () => onFilter(),
      title: _i18n.i18n.translate('expressionLegacyMetricVis.filterTitle', {
        defaultMessage: 'Click to filter by field'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, metricComponent);
  }
  return metricComponent;
};
exports.MetricVisValue = MetricVisValue;
const styles = {
  legacyMtrVisValue: ({
    euiTheme
  }) => (0, _react2.css)`
      ${(0, _eui.euiTextTruncate)()};
      font-weight: ${euiTheme.font.weight.bold};
    `,
  legacyMtrVisContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    '&.legacyMtrVis__container': {
      textAlign: 'center',
      padding: euiTheme.size.base,
      display: 'flex',
      flexDirection: 'column'
    },
    '&.legacyMtrVis__container--light': {
      color: euiTheme.colors.emptyShade
    },
    '&.legacyMtrVis__container-isfull': {
      minHeight: '100%',
      minWidth: 'max-content',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      alignItems: 'center',
      flex: '1 0 100%'
    },
    '&.legacyMtrVis__container-isfilterable': {
      cursor: 'pointer',
      transition: `transform ${euiTheme.animation.normal} ${euiTheme.animation.resistance}`,
      transform: 'translate(0, 0)',
      '&:hover, &:focus': {
        boxShadow: 'none',
        transform: 'translate(0, -2px)'
      }
    }
  })
};