"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueControlForm = ValueControlForm;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _esqlTypes = require("@kbn/esql-types");
var _esqlUtils = require("@kbn/esql-utils");
var _create_editor = require("../../../create_editor");
var _shared_form_components = require("./shared_form_components");
var _choose_column_popover = require("./choose_column_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/esql/public/triggers/esql_controls/control_flyout/value_control_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUGGESTED_INTERVAL_VALUES = ['5 minutes', '1 hour', '1 day', '1 week', '1 month'];
const INITIAL_EMPTY_STATE_QUERY = `/** Example
To get the agent field values use: 
FROM logs-* 
|  WHERE @timestamp <=?_tend and @timestamp >?_tstart
| STATS BY agent
*/`;
function ValueControlForm({
  variableType,
  initialState,
  queryString,
  variableName,
  controlFlyoutType,
  search,
  setControlState,
  valuesRetrieval,
  timeRange,
  currentApp
}) {
  var _initialState$esqlQue, _initialState$title, _initialState$width, _initialState$grow;
  const isMounted = (0, _useMountedState.default)();
  const [availableValuesOptions, setAvailableValuesOptions] = (0, _react.useState)(variableType === _esqlTypes.ESQLVariableType.TIME_LITERAL ? SUGGESTED_INTERVAL_VALUES.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [selectedValues, setSelectedValues] = (0, _react.useState)(initialState !== null && initialState !== void 0 && initialState.availableOptions ? initialState.availableOptions.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [valuesQuery, setValuesQuery] = (0, _react.useState)(variableType === _esqlTypes.ESQLVariableType.VALUES ? (_initialState$esqlQue = initialState === null || initialState === void 0 ? void 0 : initialState.esqlQuery) !== null && _initialState$esqlQue !== void 0 ? _initialState$esqlQue : INITIAL_EMPTY_STATE_QUERY : '');
  const [esqlQueryErrors, setEsqlQueryErrors] = (0, _react.useState)();
  const [queryColumns, setQueryColumns] = (0, _react.useState)(valuesRetrieval ? [valuesRetrieval] : []);
  const [label, setLabel] = (0, _react.useState)((_initialState$title = initialState === null || initialState === void 0 ? void 0 : initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : '');
  const [minimumWidth, setMinimumWidth] = (0, _react.useState)((_initialState$width = initialState === null || initialState === void 0 ? void 0 : initialState.width) !== null && _initialState$width !== void 0 ? _initialState$width : 'medium');
  const [grow, setGrow] = (0, _react.useState)((_initialState$grow = initialState === null || initialState === void 0 ? void 0 : initialState.grow) !== null && _initialState$grow !== void 0 ? _initialState$grow : false);
  const onValuesChange = (0, _react.useCallback)(selectedOptions => {
    setSelectedValues(selectedOptions);
  }, []);
  const onCreateOption = (0, _react.useCallback)((searchValue, flattenedOptions = []) => {
    if (!searchValue) {
      return;
    }
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    const newOption = {
      'data-test-subj': searchValue,
      label: searchValue,
      key: searchValue
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      setAvailableValuesOptions([...availableValuesOptions, newOption]);
    }
    setSelectedValues(prevSelected => [...prevSelected, newOption]);
  }, [availableValuesOptions]);
  const onLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
  }, []);
  const onMinimumSizeChange = (0, _react.useCallback)(optionId => {
    if (optionId) {
      setMinimumWidth(optionId);
    }
  }, []);
  const onGrowChange = (0, _react.useCallback)(e => {
    setGrow(e.target.checked);
  }, []);
  const onValuesQuerySubmit = (0, _react.useCallback)(async query => {
    try {
      (0, _esqlUtils.getESQLResults)({
        esqlQuery: query,
        search,
        signal: undefined,
        filter: undefined,
        dropNullColumns: true,
        timeRange
      }).then(results => {
        if (!isMounted()) {
          return;
        }
        const columns = results.response.columns.map(col => col.name);
        setQueryColumns(columns);
        if (columns.length === 1) {
          const valuesArray = results.response.values.map(value => value[0]);
          const options = valuesArray.filter(v => v).map(option => {
            return {
              label: String(option),
              key: String(option),
              'data-test-subj': String(option)
            };
          });
          setSelectedValues(options);
          setAvailableValuesOptions(options);
          setEsqlQueryErrors([]);
        }
      });
      setValuesQuery(query);
    } catch (e) {
      setEsqlQueryErrors([e]);
    }
  }, [isMounted, search, timeRange]);
  (0, _react.useEffect)(() => {
    if (!(selectedValues !== null && selectedValues !== void 0 && selectedValues.length) && controlFlyoutType === _esqlTypes.EsqlControlType.VALUES_FROM_QUERY) {
      if (initialState !== null && initialState !== void 0 && initialState.esqlQuery) {
        onValuesQuerySubmit(initialState.esqlQuery);
      } else if (valuesRetrieval) {
        const queryForValues = `FROM ${(0, _esqlUtils.getIndexPatternFromESQLQuery)(queryString)} | STATS BY ${valuesRetrieval}`;
        onValuesQuerySubmit(queryForValues);
      }
    }
  }, [initialState === null || initialState === void 0 ? void 0 : initialState.esqlQuery, controlFlyoutType, onValuesQuerySubmit, queryString, selectedValues === null || selectedValues === void 0 ? void 0 : selectedValues.length, valuesRetrieval, variableName]);
  (0, _react.useEffect)(() => {
    const availableOptions = selectedValues.map(value => value.label);
    // removes the question mark from the variable name
    const variableNameWithoutQuestionmark = variableName.replace(/^\?+/, '');
    const state = {
      availableOptions,
      selectedOptions: [availableOptions[0]],
      width: minimumWidth,
      title: label || variableNameWithoutQuestionmark,
      variableName: variableNameWithoutQuestionmark,
      variableType,
      esqlQuery: valuesQuery || queryString,
      controlType: controlFlyoutType,
      grow
    };
    if (!(0, _lodash.isEqual)(state, initialState)) {
      setControlState(state);
    }
  }, [controlFlyoutType, grow, initialState, label, minimumWidth, queryString, selectedValues, setControlState, valuesQuery, variableName, variableType]);
  const updateQuery = (0, _react.useCallback)(column => {
    const updatedQuery = (0, _esqlUtils.appendStatsByToQuery)(valuesQuery, column);
    onValuesQuerySubmit(updatedQuery);
  }, [onValuesQuerySubmit, valuesQuery]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, controlFlyoutType === _esqlTypes.EsqlControlType.VALUES_FROM_QUERY && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_editor.ESQLLangEditor, {
    query: {
      esql: valuesQuery
    },
    onTextLangQueryChange: q => {
      setValuesQuery(q.esql);
    },
    hideTimeFilterInfo: true,
    disableAutoFocus: true,
    errors: esqlQueryErrors,
    editorIsInline: true,
    hideRunQueryText: true,
    onTextLangQuerySubmit: async (q, a) => {
      if (q) {
        await onValuesQuerySubmit(q.esql);
      }
    },
    isDisabled: false,
    isLoading: false,
    hasOutline: true,
    formLabel: _i18n.i18n.translate('esql.flyout.valuesQueryEditor.label', {
      defaultMessage: 'Values query'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }), queryColumns.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.previewValues.placeholder', {
      defaultMessage: 'Values preview'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 13
    }
  }, queryColumns.length === 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "primary",
    css: (0, _react2.css)`
                    white-space: wrap;
                    overflow-y: auto;
                    max-height: 200px;
                  `,
    "data-test-subj": "esqlValuesPreview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 17
    }
  }, selectedValues.map(value => value.label).join(', ')) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('esql.flyout.displayMultipleColsCallout.title', {
      defaultMessage: 'Your query must return a single column'
    }),
    color: "warning",
    iconType: "warning",
    size: "s",
    "data-test-subj": "esqlMoreThanOneColumnCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esql.flyout.displayMultipleColsCallout.description",
    defaultMessage: "Your query is currently returning {totalColumns} columns. Choose column {chooseColumnPopover} or use {boldText}.",
    values: {
      totalColumns: queryColumns.length,
      boldText: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 35
        }
      }, "STATS BY"),
      chooseColumnPopover: /*#__PURE__*/_react.default.createElement(_choose_column_popover.ChooseColumnPopover, {
        columns: queryColumns,
        updateQuery: updateQuery,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 319,
          columnNumber: 27
        }
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 21
    }
  }))))), controlFlyoutType === _esqlTypes.EsqlControlType.STATIC_VALUES && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.values.label', {
      defaultMessage: 'Values'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.values.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.values.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    "data-test-subj": "esqlValuesOptions",
    options: availableValuesOptions,
    selectedOptions: selectedValues,
    onChange: onValuesChange,
    onCreateOption: onCreateOption,
    isClearable: true,
    fullWidth: true,
    compressed: true,
    css: (0, _react2.css)`
              max-height: 200px;
              overflow-y: auto;
              .euiFormControlLayoutIcons {
                align-items: flex-start;
                padding-block-start: 1ch;
              }
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlLabel, {
    label: label,
    onLabelChange: onLabelChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlWidth, {
    minimumWidth: minimumWidth,
    grow: grow,
    onMinimumSizeChange: onMinimumSizeChange,
    onGrowChange: onGrowChange
    // This property is not compatible with the unified search yet
    // we will hide this possibility for now
    ,
    hideFitToSpace: currentApp === 'discover',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 7
    }
  }));
}