"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelHealth = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ml = require("../../../../../../common/types/ml");
var _pipelines = require("../../../../../../common/types/pipelines");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_model_health.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const modelNotDownloadedText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDownloaded', {
  defaultMessage: 'Not deployed'
});
const modelNotDownloadedTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDownloaded.tooltip', {
  defaultMessage: 'This trained model can be deployed'
});
const modelDownloadingText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.downloading', {
  defaultMessage: 'Deploying'
});
const modelDownloadingTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.downloading.tooltip', {
  defaultMessage: 'This trained model is deploying'
});
const modelDownloadedText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.downloaded', {
  defaultMessage: 'Deployed'
});
const modelDownloadedTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.downloaded.tooltip', {
  defaultMessage: 'This trained model is deployed and can be started'
});
const modelStartedText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.started', {
  defaultMessage: 'Started'
});
const modelStartedTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.started.tooltip', {
  defaultMessage: 'This trained model is running and fully available'
});
const modelStartingText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.starting', {
  defaultMessage: 'Starting'
});
const modelStartingTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.starting.tooltip', {
  defaultMessage: 'This trained model is in the process of starting up and will be available shortly'
});
const modelStoppingText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.stopping', {
  defaultMessage: 'Stopping'
});
const modelStoppingTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.stopping.tooltip', {
  defaultMessage: 'This trained model is in the process of shutting down and is currently unavailable'
});
const modelDeploymentFailedText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.deploymentFailed', {
  defaultMessage: 'Deployment failed'
});
const modelNotDeployedText = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDeployed', {
  defaultMessage: 'Not started'
});
const modelNotDeployedTooltip = _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDeployed.tooltip', {
  defaultMessage: 'This trained model is not currently started. Visit the trained models page to make changes'
});
const TrainedModelHealth = ({
  modelState,
  modelStateReason,
  isDownloadable,
  onClickAction
}) => {
  let modelHealth;
  switch (modelState) {
    case _pipelines.TrainedModelState.NotDeployed:
    case _ml.MlModelDeploymentState.NotDeployed:
      modelHealth = {
        healthColor: isDownloadable ? 'subdued' : 'danger',
        healthText: isDownloadable ? modelNotDownloadedText : modelNotDeployedText,
        tooltipText: isDownloadable ? modelNotDownloadedTooltip : modelNotDeployedTooltip
      };
      break;
    case _ml.MlModelDeploymentState.Downloading:
      modelHealth = {
        healthColor: 'warning',
        healthText: modelDownloadingText,
        tooltipText: modelDownloadingTooltip
      };
      break;
    case _ml.MlModelDeploymentState.Downloaded:
      modelHealth = {
        healthColor: 'subdued',
        healthText: modelDownloadedText,
        tooltipText: modelDownloadedTooltip
      };
      break;
    case _pipelines.TrainedModelState.Starting:
    case _ml.MlModelDeploymentState.Starting:
      modelHealth = {
        healthColor: 'warning',
        healthText: modelStartingText,
        tooltipText: modelStartingTooltip
      };
      break;
    case _pipelines.TrainedModelState.Started:
    case _ml.MlModelDeploymentState.Started:
    case _ml.MlModelDeploymentState.FullyAllocated:
      modelHealth = {
        healthColor: 'success',
        healthText: modelStartedText,
        tooltipText: modelStartedTooltip
      };
      break;
    case _pipelines.TrainedModelState.Stopping:
      modelHealth = {
        healthColor: 'warning',
        healthText: modelStoppingText,
        tooltipText: modelStoppingTooltip
      };
      break;
    case _pipelines.TrainedModelState.Failed:
      modelHealth = {
        healthColor: 'danger',
        healthText: modelDeploymentFailedText,
        tooltipText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.inferencePipelineCard.modelState.deploymentFailed.tooltip",
          defaultMessage: "The trained model failed to deploy. {reason}",
          values: {
            reason: modelStateReason ? _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.deploymentFailed.tooltip.reason', {
              defaultMessage: 'Reason: {modelStateReason}',
              values: {
                modelStateReason
              }
            }) : ''
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 182,
            columnNumber: 11
          }
        })
      };
      break;
    default:
      modelHealth = {
        healthColor: 'danger',
        healthText: modelNotDeployedText,
        tooltipText: modelNotDeployedTooltip
      };
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: modelHealth.tooltipText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, onClickAction ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchTrainedModelHealthPopoverButton",
    iconSide: "right",
    flush: "both",
    iconType: "boxesHorizontal",
    onClick: () => onClickAction(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: modelHealth.healthColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, modelHealth.healthText)) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: modelHealth.healthColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, modelHealth.healthText));
};
exports.TrainedModelHealth = TrainedModelHealth;