"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConnectors = exports.FetchConnectorsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchConnectors = async ({
  fetchCrawlersOnly,
  from,
  size,
  searchQuery
}) => {
  const isInitialRequest = from === 0 && !searchQuery;
  const route = '/internal/enterprise_search/connectors';
  const query = {
    fetchCrawlersOnly,
    from,
    searchQuery,
    size
  };
  const response = await _http.HttpLogic.values.http.get(route, {
    query
  });
  return {
    ...response,
    isInitialRequest
  };
};
exports.fetchConnectors = fetchConnectors;
const FetchConnectorsApiLogic = exports.FetchConnectorsApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_connectors_api_logic'], fetchConnectors);