"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ai_assistant_data_clients = require("../../../ai_assistant_data_clients");
var _find = require("../../../ai_assistant_data_clients/find");
var _combine_find_attack_discovery_filters = require("./combine_find_attack_discovery_filters");
var _create_attack_discovery_alerts = require("./create_attack_discovery_alerts");
var _get_attack_discovery_generations = require("./get_attack_discovery_generations");
var _get_attack_discovery_generation_by_id_query = require("./get_attack_discovery_generation_by_id_query");
var _get_attack_discovery_generations_query = require("./get_attack_discovery_generations_query");
var _get_combined_filter = require("./get_combined_filter");
var _get_find_attack_discovery_alerts_aggregation = require("./get_find_attack_discovery_alerts_aggregation");
var _transform_search_response_to_alerts = require("./transforms/transform_search_response_to_alerts");
var _get_scheduled_index_pattern = require("./get_scheduled_index_pattern");
var _get_update_attack_discovery_alerts_query = require("../get_update_attack_discovery_alerts_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIRST_PAGE = 1; // CAUTION: sever-side API uses a 1-based page index convention (for consistency with similar existing APIs)
const DEFAULT_PER_PAGE = 10;
class AttackDiscoveryDataClient extends _ai_assistant_data_clients.AIAssistantDataClient {
  constructor(options) {
    super(options);
    (0, _defineProperty2.default)(this, "adhocAttackDiscoveryDataClient", void 0);
    (0, _defineProperty2.default)(this, "getAdHocAlertsIndexPattern", () => {
      if (this.adhocAttackDiscoveryDataClient === undefined) {
        throw new Error('`adhocAttackDiscoveryDataClient` is required');
      }
      return this.adhocAttackDiscoveryDataClient.indexNameWithNamespace(this.spaceId);
    });
    (0, _defineProperty2.default)(this, "getScheduledAndAdHocIndexPattern", () => {
      return [(0, _get_scheduled_index_pattern.getScheduledIndexPattern)(this.spaceId),
      // scheduled
      this.getAdHocAlertsIndexPattern() // ad-hoc
      ].join(',');
    });
    (0, _defineProperty2.default)(this, "createAttackDiscoveryAlerts", async ({
      authenticatedUser,
      createAttackDiscoveryAlertsParams
    }) => {
      if (this.adhocAttackDiscoveryDataClient === undefined) {
        throw new Error('`adhocAttackDiscoveryDataClient` is required');
      }
      return (0, _create_attack_discovery_alerts.createAttackDiscoveryAlerts)({
        adhocAttackDiscoveryDataClient: this.adhocAttackDiscoveryDataClient,
        authenticatedUser,
        createAttackDiscoveryAlertsParams,
        logger: this.options.logger,
        spaceId: this.spaceId
      });
    });
    (0, _defineProperty2.default)(this, "findAttackDiscoveryAlerts", async ({
      authenticatedUser,
      esClient,
      findAttackDiscoveryAlertsParams,
      logger
    }) => {
      const {
        alertIds,
        connectorNames,
        // <-- as a filter input
        enableFieldRendering,
        end,
        executionUuid,
        includeUniqueAlertIds,
        ids,
        search,
        shared,
        sortField = '@timestamp',
        sortOrder = 'desc',
        start,
        status,
        page = FIRST_PAGE,
        perPage = DEFAULT_PER_PAGE,
        withReplacements = false
      } = findAttackDiscoveryAlertsParams;
      const aggs = (0, _get_find_attack_discovery_alerts_aggregation.getFindAttackDiscoveryAlertsAggregation)(includeUniqueAlertIds);
      const index = this.getScheduledAndAdHocIndexPattern();
      const filter = (0, _combine_find_attack_discovery_filters.combineFindAttackDiscoveryFilters)({
        alertIds,
        connectorNames,
        end,
        executionUuid,
        ids,
        search,
        start,
        status
      });
      const combinedFilter = (0, _get_combined_filter.getCombinedFilter)({
        authenticatedUser,
        filter,
        shared
      });
      const result = await (0, _find.findDocuments)({
        aggs,
        esClient,
        filter: combinedFilter,
        index,
        logger,
        page,
        perPage,
        sortField,
        sortOrder: sortOrder
      });
      const {
        connectorNames: alertConnectorNames,
        data,
        uniqueAlertIdsCount,
        uniqueAlertIds
      } = (0, _transform_search_response_to_alerts.transformSearchResponseToAlerts)({
        logger,
        response: result.data,
        includeUniqueAlertIds,
        enableFieldRendering,
        withReplacements
      });
      return {
        connector_names: alertConnectorNames,
        data,
        page: result.page,
        per_page: result.perPage,
        total: result.total,
        unique_alert_ids_count: uniqueAlertIdsCount,
        ...(includeUniqueAlertIds ? {
          unique_alert_ids: uniqueAlertIds
        } : {})
      };
    });
    (0, _defineProperty2.default)(this, "getAttackDiscoveryGenerations", async ({
      authenticatedUser,
      eventLogIndex,
      getAttackDiscoveryGenerationsParams,
      logger,
      spaceId
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      const {
        size,
        start,
        end
      } = getAttackDiscoveryGenerationsParams;
      const generationsQuery = (0, _get_attack_discovery_generations_query.getAttackDiscoveryGenerationsQuery)({
        authenticatedUser,
        end,
        eventLogIndex,
        size,
        spaceId,
        start
      });
      return (0, _get_attack_discovery_generations.getAttackDiscoveryGenerations)({
        authenticatedUser,
        esClient,
        eventLogIndex,
        generationsQuery,
        getAttackDiscoveryGenerationsParams,
        logger,
        spaceId
      });
    });
    (0, _defineProperty2.default)(this, "bulkUpdateAttackDiscoveryAlerts", async ({
      authenticatedUser,
      enableFieldRendering,
      esClient,
      ids,
      kibanaAlertWorkflowStatus,
      logger,
      visibility,
      withReplacements
    }) => {
      const PER_PAGE = 1000;
      const indexPattern = this.getScheduledAndAdHocIndexPattern();
      if (ids.length === 0) {
        logger.debug(() => `No Attack discovery alerts to update for index ${indexPattern} in bulkUpdateAttackDiscoveryAlerts`);
        return [];
      }
      try {
        logger.debug(() => `Updating Attack discovery alerts in index ${indexPattern} with alert ids: ${ids.join(', ')}`);
        const updateByQuery = (0, _get_update_attack_discovery_alerts_query.getUpdateAttackDiscoveryAlertsQuery)({
          authenticatedUser,
          ids,
          indexPattern,
          kibanaAlertWorkflowStatus,
          visibility
        });
        const updateResponse = await esClient.updateByQuery(updateByQuery);
        await esClient.indices.refresh({
          allow_no_indices: true,
          ignore_unavailable: true,
          index: indexPattern
        });
        if (updateResponse.failures != null && updateResponse.failures.length > 0) {
          const errorDetails = updateResponse.failures.flatMap(failure => {
            const error = failure === null || failure === void 0 ? void 0 : failure.cause;
            if (error == null) {
              return [];
            }
            const id = failure.id != null ? ` id: ${failure.id}` : '';
            const details = `\nError updating attack discovery alert${id} ${error}`;
            return [details];
          });
          const allErrorDetails = errorDetails.join(', ');
          throw new Error(`Failed to update attack discovery alerts ${allErrorDetails}`);
        }
        const alertsResult = await this.findAttackDiscoveryAlerts({
          authenticatedUser,
          esClient,
          findAttackDiscoveryAlertsParams: {
            enableFieldRendering,
            ids,
            page: FIRST_PAGE,
            perPage: PER_PAGE,
            sortField: '@timestamp',
            withReplacements
          },
          logger
        });
        return alertsResult.data;
      } catch (err) {
        logger.error(`Error updating Attack discovery alerts: ${err} for ids: ${ids.join(', ')}`);
        throw err;
      }
    });
    (0, _defineProperty2.default)(this, "getAttackDiscoveryGenerationById", async ({
      authenticatedUser,
      eventLogIndex,
      executionUuid,
      logger,
      spaceId
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      const generationByIdQuery = (0, _get_attack_discovery_generation_by_id_query.getAttackDiscoveryGenerationByIdQuery)({
        authenticatedUser,
        eventLogIndex,
        executionUuid,
        spaceId
      });
      const result = await (0, _get_attack_discovery_generations.getAttackDiscoveryGenerations)({
        authenticatedUser,
        esClient,
        eventLogIndex,
        generationsQuery: generationByIdQuery,
        getAttackDiscoveryGenerationsParams: {
          size: 1
        },
        logger,
        spaceId
      });
      if ((result === null || result === void 0 ? void 0 : result.generations[0]) == null) {
        throw Object.assign(new Error(`Generation with execution_uuid ${executionUuid} not found`), {
          statusCode: 404
        });
      }
      return result === null || result === void 0 ? void 0 : result.generations[0];
    });
    this.options = options;
    this.adhocAttackDiscoveryDataClient = this.options.adhocAttackDiscoveryDataClient;
  }
  async refreshEventLogIndex(eventLogIndex) {
    const esClient = await this.options.elasticsearchClientPromise;
    await esClient.indices.refresh({
      allow_no_indices: true,
      ignore_unavailable: true,
      index: eventLogIndex
    });
  }
}
exports.AttackDiscoveryDataClient = AttackDiscoveryDataClient;